<?php

namespace WM\CronReporterBundle\Transports\Drivers;

use WM\CronReporterBundle\Transports\TransportInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

abstract class AbstractTransport implements TransportInterface
{

    /**
     * @var array
     */
    protected $configuration;

    /**
     * @inheritdoc
     */
    public function setConfiguration(array $configuration): TransportInterface
    {
        $resolver = $this->configureOptions(new OptionsResolver());
        $this->configuration = $resolver->resolve($configuration);

        return $this;
    }

    /**
     * @inheritdoc
     */
    private function configureOptions(OptionsResolver $resolver)
    {
        return $resolver
            ->setRequired(['transport',])
            ->setAllowedTypes('transport', 'string');
    }
}
