<?php

namespace WM\CronReporterBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use WM\CronReporterBundle\Transports\TransportFactory;

class TransportPass implements CompilerPassInterface
{

    /**
     * @inheritdoc
     */
    public function process(ContainerBuilder $container)
    {
        if (!$container->hasParameter('wm_cron_reporter.fallback')) {
            return;
        }

        $config = $container->getParameter('wm_cron_reporter.fallback');
        $taggedServices = $container->findTaggedServiceIds('wm_cron_reporter.transport');
        $factory = $container->getDefinition(TransportFactory::class);
        foreach ($taggedServices as $id => $tags) {
            $definition = $container->getDefinition($id)->addMethodCall('setConfiguration', [$config]);
            $container->setDefinition($id, $definition);
            $factory->addMethodCall('addTransport', [new Reference($id)]);
        }
    }
}
