<?php

namespace WM\CronReporterBundle\Component\Console;

class SharedBufferCronReporterOutput extends CronReporterOutput
{

    /**
     * @var string
     */
    private static $sharedBuffer = '';

    /**
     * SharedBufferCronReporterOutput constructor.
     *
     * @inheritdoc
     */
    public function __construct($verbosity = self::VERBOSITY_NORMAL, $decorated = null, $formatter = null)
    {
        parent::__construct($verbosity, $decorated, $formatter);
        $this->setErrorOutput(new CronReporterStreamOutput($this->openErrorStream(), $verbosity, $decorated,
            $this->getFormatter(), $this));
    }

    /**
     * @return string
     */
    public function getSharedBuffer(): string
    {
        return self::$sharedBuffer;
    }

    /**
     * @param string $message
     * @param bool   $newline
     *
     * @return self
     */
    public function addMessage(string $message, bool $newline): SharedBufferCronReporterOutput
    {
        self::$sharedBuffer .= $newline ? $message . PHP_EOL : $message;

        return $this;
    }

    /**
     * @return self
     */
    public function clearSharedBuffer(): SharedBufferCronReporterOutput
    {
        self::$sharedBuffer = '';

        return $this;
    }

    /**
     * @inheritdoc
     */
    protected function doWrite($message, $newline)
    {
        parent::doWrite($message, $newline);

        self::$sharedBuffer .= $newline ? $message . PHP_EOL : $message;
    }
}
