## Server Integrations

- [Standard Server](executing-queries.md#using-server) – Out of the box integration with any PSR-7 compatible framework (like [Slim](https://slimframework.com) or [Laminas Mezzio](https://docs.mezzio.dev/mezzio/))
- [Lighthouse](https://github.com/nuwave/lighthouse) – Laravel package, SDL-first
- [Laravel GraphQL](https://github.com/rebing/graphql-laravel) - Laravel package, code-first
- [OverblogGraphQLBundle](https://github.com/overblog/GraphQLBundle) – Symfony bundle
- [WP-GraphQL](https://github.com/wp-graphql/wp-graphql) - WordPress plugin
- [Siler](https://github.com/leocavalcante/siler) - Flat files and plain-old PHP functions, supports Swoole
- [API Platform](https://api-platform.com/docs/core/graphql) - Creates a GraphQL API from PHP models

## Server Utilities

- [GraphQLite](https://graphqlite.thecodingmachine.io) – Use PHP Annotations to define your schema
- [GraphQL Doctrine](https://github.com/Ecodev/graphql-doctrine) – Define types with Doctrine ORM annotations
- [DataLoaderPHP](https://github.com/overblog/dataloader-php) – Implements [deferred resolvers](data-fetching.md#solving-n1-problem)
- [GraphQL Upload](https://github.com/Ecodev/graphql-upload) – PSR-15 middleware to support file uploads in GraphQL
- [GraphQL Batch Processor](https://github.com/vasily-kartashov/graphql-batch-processing) – Provides a builder interface for defining collection, querying, filtering, and post-processing logic of batched data fetches
- [GraphQL Utils](https://github.com/simPod/GraphQL-Utils) – Objective schema definition builders (no need for arrays anymore)
- [Relay Library](https://github.com/ivome/graphql-relay-php) – Helps construct Relay related schema definitions
- [GraphQL PHP Validation Toolkit](https://github.com/shmax/graphql-php-validation-toolkit) - Small library for validation of user input

* [MLL Scalars](https://github.com/mll-lab/graphql-php-scalars) - Collection of custom scalar types

## GraphQL Clients

- [GraphiQL](https://github.com/graphql/graphiql) – Graphical interactive in-browser GraphQL IDE
- [GraphQL Playground](https://github.com/graphql/graphql-playground) – GraphQL IDE for better development workflows (GraphQL Subscriptions, interactive docs & collaboration)
- [Altair GraphQL Client](https://altair.sirmuel.design) - Beautiful feature-rich GraphQL Client for all platforms
- [Sailor](https://github.com/spawnia/sailor) - Typesafe GraphQL client for PHP
