import { on } from "@Ui/js/dom/events";

const SEARCH_FORMS = document.querySelectorAll(".js-search");

export default function handleSearch() {
  if (!SEARCH_FORMS.length) {
    return false;
  }

  SEARCH_FORMS.forEach((item) => {
    const INPUT_SEARCH_TEXT = item.querySelector(".js-input-txt");
    const BTN_SEARCH_TRIGGER = item.querySelector(".js-submit-form");

    on(INPUT_SEARCH_TEXT, "keyup", (e) => {
      if (e.target.value === "") {
        BTN_SEARCH_TRIGGER.disabled = true;
      } else {
        BTN_SEARCH_TRIGGER.disabled = false;
      }
    });
  });
}
