const showtimesBanner = document.querySelector('.js-banner-showtimes');
const urlApi = "https://www.allocine.fr/_/showtimes-media/";
const movieId = showtimesBanner?.dataset?.movieId;
const months = ["01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"];

let rangeDate = null;

function getRangeDate() {
    const now = new Date();

    return {
        'from': new Date(now).toISOString(),
        'to': new Date(now.setDate(now.getDate() + 28)).toISOString()
    }
}

function setTheaterInfo(currentTheater) {
  const theater = currentTheater.theater;
  const showtime = currentTheater.showtimes[0];

  const theaterNameElement = showtimesBanner.querySelector('.theater-name');
  const theaterDateElement = showtimesBanner.querySelector('.theater-date');
  const theaterLocationElement = showtimesBanner.querySelector('.theater-location');

  if (theaterNameElement) {
    theaterNameElement.textContent = theater.name;
  }

  if (theaterLocationElement) {
    theaterLocationElement.textContent = `${theater.location.address} - ${theater.location.zip} ${theater.location.city}`;
  }

  if(theaterDateElement) {
    const date = new Date(showtime.startsAt).toLocaleDateString(undefined, {
      weekday: "long",
      year: "numeric",
      month: "long",
      day: "numeric",
    });

    theaterDateElement.textContent = date;
  }
};

function setShowtimesInfo(currentTheater) {
  const showtimes = currentTheater.showtimes;
  const ctaContainerElement = showtimesBanner.querySelector('.cta-container');

  if (!ctaContainerElement) {
    return false;
  }

  const showtimesBtnHTML = showtimes.slice(0, 3).map(showtime => {
    const date      = new Date(showtime.startsAt);

    let minutes     = date.getMinutes();
    let hours       = date.getHours();
    let minutesNew  = (minutes < 10) ? "0" + minutes : minutes;
    let hoursNew    = (hours < 10) ? "0" + hours : hours;

    return `
      ${showtime.data.ticketing.length > 0 ? `<a
        class="btn cta showtime-item"
        href="${showtime.data.ticketing[0].urls[0]}"
        target="_blank"
        rel="noopener"
      >
        <span class="showtime-item-hour">
          ${hoursNew}:${minutesNew}
        </span>
      </a>` : ''}
    `;

  }).join('');

  ctaContainerElement.innerHTML = showtimesBtnHTML;
}

const getTheaterList = async (movieId, latitude, longitude, radius) => {
    if (rangeDate) {
        var bodyRequest = `action=showtimes&movieId=${movieId}&latitude=${latitude}&longitude=${longitude}&radius=${radius}&from=${rangeDate?.from}&to=${rangeDate?.to}`;
    } else {
        var bodyRequest = `action=showtimes&movieId=${movieId}&latitude=${latitude}&longitude=${longitude}&radius=${radius}}`;
    }

    try {
        const req = await fetch(urlApi, {
            method: "POST",
            body: bodyRequest,
            mode: 'cors',
            headers: {
                'Content-type': 'application/x-www-form-urlencoded'
            }
        });

        return await req.json();

    } catch (err) {
        console.log('err : ', err);
        // KEEP THE BASE VERSION WITH CTA SERVED BY TWIG
        return;
    }
};

const getAvailableTheaterByShowtime = theatersList => {
    if(!theatersList.length) {
        return null;
    }

    for (const theater of theatersList) {
        for (const showtime of theater.showtimes) {
            if (showtime.data.ticketing.length > 0) {
              return theater;
            }
        }
    }

    return null;
};

const showShowtimes = async (coords) => {
    if (movieId) {
        var theatersList = null;

        theatersList = await getTheaterList(movieId, coords.latitude, coords.longitude, '30000');

        const currentTheater = getAvailableTheaterByShowtime(theatersList);

        if (currentTheater) {
            // SHOW SHOWTIMES
            setTheaterInfo(currentTheater);
            setShowtimesInfo(currentTheater);
            return;
        } else {
            // KEEP THE BASE VERSION WITH CTA SERVED BY TWIG
            return;
        }
    }
    else {
        // KEEP THE BASE VERSION WITH CTA SERVED BY TWIG
        return;
    }
}

export default async function initBannerShowtimes() {
  // check if the geolocation is in browser
  if (!navigator.geolocation) {
    console.warn('Votre navigateur ne supporte pas geolocation');
    return;
  }

  // get the location if success request
  // replace 'pos' by 'coords' after the test
  const getLocationSuccess = async (coords) => {
    rangeDate = getRangeDate();

    showShowtimes(coords);
  }

  // set error if the location is not a success
  const getLocationError = err => {
    console.warn(`ERROR(${err.code}): ${err.message}`);
    // KEEP THE BASE VERSION WITH CTA SERVED BY TWIG
  }

  try {
    const getLocation = await fetch("https://cdn.lib.getjad.io/geoloc/cloudflare");

    const coords = {
      latitude: getLocation.headers.get("x-wb-lat"),
      longitude: getLocation.headers.get("x-wb-lon"),
    }

    getLocationSuccess(coords);
  } catch (err) {
    getLocationError(err);
  }
}

