export default (targets = []) => {
  if (window.IntersectionObserver && targets.length) {

    targets.forEach((item) => {
      const element = item.element;

      if (!element || !item.callback) {
        return false;
      }

      const options = item.options || {}

      let observer = new IntersectionObserver(entries => {
        entries.forEach((entry) => {
          // Do whatever you want on user side
          item.callback(entry, observer);
        });
      }, options);

      observer.observe(element);
    })
  }
}
