// Experimental javascript API
// https://developer.mozilla.org/en-US/docs/Web/API/Intersection_Observer_API
//
// The IntersectionObserver interface of the Intersection Observer API provides a way to
// asynchronously observe changes in the intersection of a target element with an ancestor
// element or with a top-level document's viewport. The ancestor element or viewport is referred
// to as the root.
export const lazyLoadCall = (anchors, callback, options, unobserve = true) => {
  if (window.IntersectionObserver) {
      const intersectionObserver = new window.IntersectionObserver(entries => {
          entries.forEach(entry => {
              if (entry.intersectionRatio > 0) {
                  // prevent recall
                  if (unobserve) {
                    intersectionObserver.unobserve(entry.target);
                  }
                  callback(entry.target);
              }
          });
      }, options);

      for (const anchor of anchors) intersectionObserver.observe(anchor);
  } else {
      // when IntersectionObserver is unavailable
      // abort lazy loading callback
      for (const anchor of anchors) callback(anchor);
  }
};
