<?php

declare(strict_types=1);

namespace Webedia\UiBundle\Service;

use Knp\Menu\FactoryInterface;
use Knp\Menu\ItemInterface;

final class MenuBuilder {

    public function __construct(
        private FactoryInterface $factory,
        private array $menusConfig = []
    ) {
    }

    public function createMainMenu(): ItemInterface {
        return $this->createMenu('main_menu');
    }

    public function createLinkBar(): ItemInterface {
        return $this->createMenu('link_bar');
    }

    public function hasMenu(string $menuId): bool {
        return isset($this->menusConfig[$menuId]);
    }

    public function createMenu(string $menuId): ItemInterface {
        if (!$this->hasMenu($menuId)) {
            return $this->factory->createItem('root');
        }

        return $this->buildMenuFromConfig($this->menusConfig[$menuId]);
    }

    private function buildMenuFromConfig($menuConfig, ?ItemInterface $menu = null): ItemInterface {
        if (null === $menu) {
            $menu = $this->factory->createItem('root');
        }

        foreach($menuConfig['children'] ?? [] as $child) {
            $childMenu = $menu->addChild($child['label'], [
                'route' => $child['route'],
                'routeParameters' => $child['route_parameters']
            ]);

            if (isset($child['children']) && count($child['children']) > 0) {
                $this->buildMenuFromConfig($child, $childMenu);
            }
        }

        return $menu;
    }
}
