import loadScript from "load-script";

import { getConsentForGoogle } from "@Ui/js/consent/didomi";
import { getConsentState } from "@Ui/js/consent/tcfApi";
import { deferToLoad } from "@Ui/js/dom/events";

const OUTBRAIN_URL = "//widgets.outbrain.com/outbrain.js";
const OUTBRAIN_URL_COOKIELESS = `${OUTBRAIN_URL}?i=fabcdb12`;
let loaded = false;

export default async function loadOutbrain() {
  if (loaded) {
    return;
  }

  loaded = true;

  const outbrainAnchor = document.querySelector(".OUTBRAIN");

  if (!outbrainAnchor) {
    return;
  }

  await Promise.all([getConsentState(true), deferToLoad()]);

  // In that case CMP was validated but with a paiement and user disagree to all cookies
  const googleConsent = await getConsentForGoogle();
  if (!googleConsent) {
    loadScript(OUTBRAIN_URL_COOKIELESS);
    return;
  }

  loadScript(OUTBRAIN_URL);
}
