import loadScript from "load-script";

let YT_MAIN_PLAYER_INSTANCE = null;

const YT_PLAYER_ID = "youtube-player";
const MAIN_PLAYER_FRAME = document.getElementById(YT_PLAYER_ID);

export default function loadYtPlayer(onStateChangeCallback = null) {
  return new Promise((resolve) => {
    if (!MAIN_PLAYER_FRAME) {
      resolve();
      return;
    }

    const videoId = MAIN_PLAYER_FRAME.getAttribute("data-video-id");

    if (!videoId) {
      resolve();
      return;
    }

    loadScript("https://www.youtube.com/player_api", () => {
      window.onYouTubePlayerAPIReady = function () {
        YT_MAIN_PLAYER_INSTANCE = new YT.Player(YT_PLAYER_ID, {
          width: "580",
          height: "326",
          videoId: videoId,
          playerVars: {
            autoplay: 0,
            controls: 1,
            rel: 0, // Don't show related videos from other channels
            modestbranding: 1, // Hide YouTube logo
            fs: 1, // Allow fullscreen
            cc_load_policy: 0, // Don't show captions by default
            iv_load_policy: 3, // Hide video annotations
            autohide: 0, // Keep controls visible
          },
          events: {
            onStateChange: onStateChangeCallback,
          }
        });

        window.YT_MAIN_PLAYER_INSTANCE = YT_MAIN_PLAYER_INSTANCE;
        resolve({ instance: YT_MAIN_PLAYER_INSTANCE, currentVideoId: videoId });
      };
    });
  });
}
