// WEBSITE_HAS_CONSENT is a constant that let global code knows if they need to go through the consent
// It have to be setted in each website. By default it's set to true to be CNIL Compliant, so be carrefulwhen working on intl website version

import { on } from "../dom/events";

const WEBSITE_HAS_CONSENT = window?._GLOBALS?.constants?.WEBSITE_HAS_CONSENT;

let gaConsent = null;

const google = "google";
export const googleana = "c:googleana-XMqagawa";

export function getConsentForId(id) {
  let consents = null;

  const didomi = window.Didomi || window.top?.Didomi;

  if (!didomi) {
    return consents;
  }

  if (didomi.isConsentRequired()) {
    consents = didomi.getUserConsentStatusForVendor(id);
  }

  return consents;
}

export async function getVendorsConsent(
  arrayConsentsIds,
  timeout = true
) {
  return new Promise((resolve) => {
    if (!WEBSITE_HAS_CONSENT) {
      resolve(true);
      return;
    }

    const didomiOnReady = window.didomiOnReady || window.top?.didomiOnReady;

    if (!didomiOnReady || !arrayConsentsIds.length) {
      resolve(false);
      return;
    }

    if (gaConsent) {
      resolve(gaConsent);
      return;
    }

    let vendorTimeout = null;
    if (timeout) {
      vendorTimeout = setTimeout(() => {
        resolve(false);
      }, 3000);
    }

    didomiOnReady.push(() => {
      const consentArray = arrayConsentsIds.map((item) =>
        getConsentForId(item)
      );

      if (vendorTimeout) {
        clearTimeout(vendorTimeout);
      }

      gaConsent = consentArray.reduce((acc, currentValue) => {
        if (!currentValue) {
          return false;
        }

        // by definition this will always be true :
        return acc && currentValue;
      });

      resolve(gaConsent);
    });
  });
}

export async function getConsentForAnalitycs(timeout) {
  return await getVendorsConsent([googleana, google], timeout);
}

export async function getConsentForGoogle() {
  // use for one tag implementation
  return await getVendorsConsent([google]);
}

export function triggerDidomiPopup(domElementSelector, type) {
  const elems = document.querySelectorAll(domElementSelector);

  if (!elems) {
    return false;
  }

  elems.forEach((element) => {
    on(element, "click", (e) => {
      e.preventDefault();

      if (!window.Didomi) {
        return false;
      }

      switch (type) {
        case "notice":
          window.Didomi.notice.show();
          break;
        case "preferences":
          window.Didomi.preferences.show();
          break;
        default:
          return false;
      }
    });
  });
}
