import { on } from "../../dom/events";

//VARIABLES
const SHARE_BTN = document.querySelectorAll(".js-share");

//FUNCTION
export default function shareOnMobile() {
//Event (open mobile panel)
    SHARE_BTN.forEach(item => {
        on(item, "click", async () => {
            const SHARE_DATA = {
                title: item.dataset.title || window.document.title,
                url: item.dataset.href || window.document.location.href
            }

            if (item.dataset.text) {
                SHARE_DATA.text = item.dataset.text;
            }

            try {
                await navigator.share(SHARE_DATA);
            }
            catch (error)  {
                console.debug(error);
            }
        }); 
    }); 
}