export default function initSmallBanner(containerSelector) {
const bannerTemplate = document.getElementById('small-banner-template');

if (!bannerTemplate) {
    return;
}

if (!containerSelector) {
    return;
}
// To retrieve the page content, pass the selector
// as a parameter to initSmallBanner(#my-page) call from the project's default.js
const contentContainer = typeof containerSelector === 'string'
    ? document.querySelector(containerSelector)
    : containerSelector;
    
if (!contentContainer) {
    return;
}

const firstMedia = contentContainer.querySelector('img, video, iframe, embed, object, audio');
if (!firstMedia) {
    return;
}

// Find the element after which to insert the banner
const nextElement = firstMedia.nextElementSibling;
const insertAfterElement = (nextElement && nextElement.matches('.credit, font.credit, div.credit, p.credit, span.credit, copyright')) 
    ? nextElement 
    : firstMedia;

insertAfterElement.after(bannerTemplate);
}