<?php


declare(strict_types=1);

namespace Webedia\UiBundle\Twig;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class UiExtension extends AbstractExtension
{
    // constructor
    public function __construct(
        private bool $seoBundleEnabled = false,
        private bool $nativePlacementsEnabled = false
    )
    {

    }

    public function getFunctions(): array
    {
        $functions = [
            new TwigFunction('is_knp_menu', [$this, 'isKnpMenu']),
            new TwigFunction('is_native_placements_enabled', [$this, 'isNativePlacementsEnabled']),
        ];

        // fallback if SeoBundle is not registered
        if (!$this->seoBundleEnabled) {
            $functions[] = new TwigFunction('externalUrl', [$this, 'externalUrl']);
        }

        return $functions;
    }

    public function isNativePlacementsEnabled(): bool
    {
        return $this->nativePlacementsEnabled;
    }

    public function externalUrl(string $uri): string
    {
        return $uri;
    }

    public function isKnpMenu($item): bool
    {
        return is_object($item) && $item instanceof \Knp\Menu\ItemInterface;
    }
}
