/* global dataLayer */
import loadScript from 'load-script';

import { hasAdblock } from './ads';
import { deferToLoad } from '../dom/events';
import { getConsentState } from "../consent/tcfApi";

const GTM_ID = window._GLOBALS?.gtm?.id;
const GOOGLE_TAG_MANAGER_URL = GTM_ID ? `//www.googletagmanager.com/gtm.js?id=${GTM_ID}` : null;

let loaded = false;

/**
 * The actual loading of the google client, called once cookies are set.
 * @param  {Function} callback - the function to execute once google client api is loaded
 * @param  {Object}   options  - options for the loading of the script
 * @return {void}
 */
export default async function loadGoogleTagManager(callback = null, options = {}) {
    if (!GOOGLE_TAG_MANAGER_URL) {
        return false;
    }

    if (loaded && typeof callback === 'function') {
        callback();
        return false;
    }

    const dataLayer = window.dataLayer;

    if (dataLayer) {
        dataLayer[0].current_url = document.location.href;

        dataLayer.push({ 'gtm.start': new Date().getTime(), event: 'gtm.js' });

        dataLayer.push({ isAdblock: hasAdblock() });
    }

    await Promise.all([getConsentState(), deferToLoad()]);

    loadScript(GOOGLE_TAG_MANAGER_URL, options, () => {
        loaded = true;
        if (typeof callback === 'function') {
            callback();
        }
    });
}
