/**
 * layout single item left Section Stories
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters, TitleMarkup } from '../../../.storybook/types';

interface LayoutSingleItemLeftArgs {
  title_text: string;
  title_markup: TitleMarkup;
}

const meta: Meta<LayoutSingleItemLeftArgs> = {
  title: 'Sections/dynamic content/layout single item left',
  parameters: {
    docs: {
      description: {
        component: 'layout single item left section layout for UI-Bundle',
      },
    },
    twig: {
      template: '_stories/dynamic_content-layout_single_item_left-story.html.twig',
      componentPath: 'section/dynamic_content/layout_single_item_left',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    title_text: {
      control: 'text',
      description: 'Section title',
      table: { category: 'Content' },
    },
    title_markup: {
      control: 'select',
      options: ['h1', 'h2', 'h3', 'div'],
      description: 'Title HTML tag',
      table: { category: 'Semantic' },
    },
  },
};

export default meta;
type Story = StoryObj<LayoutSingleItemLeftArgs>;

export const Default: Story = {
  args: {
    title_text: 'layout single item left',
    title_markup: 'h2',
  },
};
