/**
 * layout roller uig Section Stories
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters, TitleMarkup } from '../../../.storybook/types';

interface LayoutRollerBigArgs {
  title_text: string;
  title_markup: TitleMarkup;
}

const meta: Meta<LayoutRollerBigArgs> = {
  title: 'Sections/dynamic content/layout roller uig',
  parameters: {
    docs: {
      description: {
        component: 'layout roller uig section layout for UI-Bundle',
      },
    },
    twig: {
      template: '_stories/dynamic_content-layout_roller_big-story.html.twig',
      componentPath: 'section/dynamic_content/layout_roller_big',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    title_text: {
      control: 'text',
      description: 'Section title',
      table: { category: 'Content' },
    },
    title_markup: {
      control: 'select',
      options: ['h1', 'h2', 'h3', 'div'],
      description: 'Title HTML tag',
      table: { category: 'Semantic' },
    },
  },
};

export default meta;
type Story = StoryObj<LayoutRollerBigArgs>;

export const Default: Story = {
  args: {
    title_text: 'layout roller uig',
    title_markup: 'h2',
  },
};
