/**
 * layout 2 cols ads Section Stories
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters, TitleMarkup } from '../../../.storybook/types';

interface Layout2ColsAdsArgs {
  title_text: string;
  title_markup: TitleMarkup;
}

const meta: Meta<Layout2ColsAdsArgs> = {
  title: 'Sections/dynamic content/layout 2 cols ads',
  parameters: {
    docs: {
      description: {
        component: 'layout 2 cols ads section layout for UI-Bundle',
      },
    },
    twig: {
      template: '_stories/dynamic_content-layout_2_cols_ads-story.html.twig',
      componentPath: 'section/dynamic_content/layout_2_cols_ads',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    title_text: {
      control: 'text',
      description: 'Section title',
      table: { category: 'Content' },
    },
    title_markup: {
      control: 'select',
      options: ['h1', 'h2', 'h3', 'div'],
      description: 'Title HTML tag',
      table: { category: 'Semantic' },
    },
  },
};

export default meta;
type Story = StoryObj<Layout2ColsAdsArgs>;

export const Default: Story = {
  args: {
    title_text: 'layout 2 cols ads',
    title_markup: 'h2',
  },
};
