/**
 * Audion Reader Module Stories
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface AudionReaderArgs {
  audion_reader_url: string;
}

const meta: Meta<AudionReaderArgs> = {
  title: 'Modules/Player Audion/Audion Reader',
  parameters: {
    docs: { description: { component: 'Audion reader component for audio content embedding. Renders a placeholder div that gets hydrated by the Audion player script.' } },
    twig: { template: 'module/player_audion/audion_reader.html.twig', renderMode: 'include', componentPath: 'module/player_audion/audion_reader', argsToContext: (args) => args },
  } as StoryParameters,
  argTypes: {
    audion_reader_url: {
      control: 'text',
      description: 'URL for the Audion embed source',
      table: { category: 'Content' },
    },
  },
};

export default meta;
type Story = StoryObj<AudionReaderArgs>;

export const Default: Story = {
  args: {
    audion_reader_url: 'https://example.com/audion-embed',
  },
};
