/**
 * Player Internal YT Module Stories
 *
 * Internal YouTube video player component.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface PlayerInternalYTArgs {
  video_id: string;
  player_thumbnail: string;
  is_main_media: boolean;
}

const meta: Meta<PlayerInternalYTArgs> = {
  title: 'Modules/Player/Player Internal YT',
  parameters: {
    docs: {
      description: {
        component: `Internal YouTube video player with thumbnail preview.

**Features:**
- Renders a YouTube player placeholder with video ID
- Displays thumbnail preview that gets replaced by the actual player
- Supports main media designation for page-level player`,
      },
    },
    twig: {
      template: 'module/player/player_internal_yt.html.twig',
      renderMode: 'include',
      componentPath: 'module/player/player_internal_yt',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    video_id: {
      control: 'text',
      description: 'YouTube video ID',
      table: { category: 'Content' },
    },
    player_thumbnail: {
      control: 'text',
      description: 'Thumbnail image URL',
      table: { category: 'Content' },
    },
    is_main_media: {
      control: 'boolean',
      description: 'Whether this is the main media player',
      table: { category: 'Behavior' },
    },
  },
};

export default meta;
type Story = StoryObj<PlayerInternalYTArgs>;

export const Default: Story = {
  args: {
    video_id: 'dQw4w9WgXcQ',
    player_thumbnail: 'https://picsum.photos/580/326',
    is_main_media: false,
  },
};

export const MainPlayer: Story = {
  args: {
    video_id: 'dQw4w9WgXcQ',
    player_thumbnail: 'https://picsum.photos/580/326',
    is_main_media: true,
  },
};
