/**
 * Player Internal Module Stories
 *
 * Internal Dailymotion video player component.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface PlayerInternalArgs {
  video_id: string;
  player_id: string;
  player_thumbnail: string;
  is_main_media: boolean;
  player_position: string;
}

const meta: Meta<PlayerInternalArgs> = {
  title: 'Modules/Player/Player Internal',
  parameters: {
    docs: {
      description: {
        component: `Internal Dailymotion video player with thumbnail preview.

**Features:**
- Renders a Dailymotion player placeholder with data attributes
- Supports video_id or playlist_id for content
- Configurable player_id for different player configurations
- Optional thumbnail preview image
- Player position tracking for analytics`,
      },
    },
    twig: {
      template: 'module/player/player_internal.html.twig',
      renderMode: 'include',
      componentPath: 'module/player/player_internal',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    video_id: {
      control: 'text',
      description: 'Dailymotion video ID',
      table: { category: 'Content' },
    },
    player_id: {
      control: 'text',
      description: 'Dailymotion player configuration ID',
      table: { category: 'Player' },
    },
    player_thumbnail: {
      control: 'text',
      description: 'Thumbnail image URL',
      table: { category: 'Content' },
    },
    is_main_media: {
      control: 'boolean',
      description: 'Whether this is the main media player',
      table: { category: 'Behavior' },
    },
    player_position: {
      control: 'select',
      options: ['playertop', 'playercontent'],
      description: 'Player position for analytics',
      table: { category: 'Analytics' },
    },
  },
};

export default meta;
type Story = StoryObj<PlayerInternalArgs>;

export const Default: Story = {
  args: {
    video_id: 'x8j9k2l',
    player_id: 'xbcde',
    player_thumbnail: 'https://picsum.photos/580/326',
    is_main_media: false,
    player_position: 'playercontent',
  },
};

export const MainPlayer: Story = {
  args: {
    video_id: 'x8j9k2l',
    player_id: 'xabcd',
    player_thumbnail: 'https://picsum.photos/580/326',
    is_main_media: true,
    player_position: 'playertop',
  },
};
