/**
 * Player External Module Stories
 *
 * External iframe-based video player for third-party embeds.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface PlayerExternalArgs {
  iframe_src: string;
  iframe_title: string;
  loading: 'lazy' | 'eager';
  allowfullscreen: boolean;
}

const meta: Meta<PlayerExternalArgs> = {
  title: 'Modules/Player/Player External',
  parameters: {
    docs: {
      description: {
        component: `External video player using iframe embeds for third-party video sources (YouTube, Vimeo, etc.).

**Features:**
- Renders an iframe with configurable src and title
- Supports lazy loading for performance
- Optional fullscreen and autoplay attributes`,
      },
    },
    twig: {
      template: 'module/player/player_external.html.twig',
      renderMode: 'include',
      componentPath: 'module/player/player_external',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    iframe_src: {
      control: 'text',
      description: 'Iframe source URL',
      table: { category: 'Content' },
    },
    iframe_title: {
      control: 'text',
      description: 'Iframe title for accessibility',
      table: { category: 'Accessibility' },
    },
    loading: {
      control: 'select',
      options: ['lazy', 'eager'],
      description: 'Loading strategy',
      table: { category: 'Performance' },
    },
    allowfullscreen: {
      control: 'boolean',
      description: 'Allow fullscreen mode',
      table: { category: 'Behavior' },
    },
  },
};

export default meta;
type Story = StoryObj<PlayerExternalArgs>;

export const Default: Story = {
  args: {
    iframe_src: 'https://www.youtube.com/embed/dQw4w9WgXcQ',
    iframe_title: 'Video Player',
    loading: 'lazy',
    allowfullscreen: true,
  },
};

export const Vimeo: Story = {
  args: {
    iframe_src: 'https://player.vimeo.com/video/76979871',
    iframe_title: 'Vimeo Video',
    loading: 'lazy',
    allowfullscreen: true,
  },
};
