/**
 * Player Footer Module Stories
 *
 * Video player section for native advertising campaigns.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface PlayerFooterArgs {
  title: string;
  subtitle: string;
  video_id: string;
  player_id: string;
  player_thumb: string;
  campaign_id: string;
}

const meta: Meta<PlayerFooterArgs> = {
  title: 'Modules/Native Placements/Player Footer',
  parameters: {
    docs: {
      description: {
        component: `Video player section for sponsored/native content campaigns.

**Features:**
- Section title and subtitle
- Integrated Dailymotion player
- Campaign tracking support
- Customizable player thumbnail`,
      },
    },
    twig: {
      template: '_stories/native_placements-player_footer-story.html.twig',
      componentPath: 'module/native_placements/player_footer',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    title: {
      control: 'text',
      description: 'Section title',
      table: { category: 'Content' },
    },
    subtitle: {
      control: 'text',
      description: 'Section subtitle/link text',
      table: { category: 'Content' },
    },
    video_id: {
      control: 'text',
      description: 'Dailymotion video ID',
      table: { category: 'Player' },
    },
    player_id: {
      control: 'text',
      description: 'Dailymotion player ID',
      table: { category: 'Player' },
    },
    player_thumb: {
      control: 'text',
      description: 'Player thumbnail URL',
      table: { category: 'Player' },
    },
    campaign_id: {
      control: 'text',
      description: 'Campaign ID for tracking',
      table: { category: 'Tracking' },
    },
  },
};

export default meta;
type Story = StoryObj<PlayerFooterArgs>;

export const Default: Story = {
  args: {
    title: 'Featured Video',
    subtitle: 'Watch our latest content',
    video_id: 'x8j9k2l',
    player_id: 'xbcde',
    player_thumb: 'https://picsum.photos/580/326',
    campaign_id: 'storybook-demo',
  },
};

export const SponsoredContent: Story = {
  args: {
    title: 'Sponsored by Brand',
    subtitle: 'Discover more on brand.com',
    video_id: 'x8j9k2l',
    player_id: 'xbcde',
    player_thumb: 'https://picsum.photos/580/326',
    campaign_id: 'brand-campaign-2024',
  },
};
