/**
 * Banner Small Module Stories
 *
 * Compact promotional banner for native advertising placements.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface BannerSmallArgs {
  partner_logo: string;
  title: string;
  description: string;
  cta_text: string;
  cta_url: string;
  bg_color: string;
  text_color: string;
  cta_bg_color: string;
  cta_text_color: string;
}

const meta: Meta<BannerSmallArgs> = {
  title: 'Modules/Native Placements/Banner Small',
  parameters: {
    docs: {
      description: {
        component: `Compact promotional banner for inline native advertising.

**Features:**
- Partner logo display
- Title and description text
- Call-to-action button
- Configurable color scheme via CSS variables`,
      },
    },
    twig: {
      template: '_stories/native_placements-banner_small-story.html.twig',
      componentPath: 'module/native_placements/banner_small',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    partner_logo: {
      control: 'text',
      description: 'Partner logo URL',
      table: { category: 'Content' },
    },
    title: {
      control: 'text',
      description: 'Banner title',
      table: { category: 'Content' },
    },
    description: {
      control: 'text',
      description: 'Banner description',
      table: { category: 'Content' },
    },
    cta_text: {
      control: 'text',
      description: 'CTA button text',
      table: { category: 'CTA' },
    },
    cta_url: {
      control: 'text',
      description: 'CTA button URL',
      table: { category: 'CTA' },
    },
    bg_color: {
      control: 'color',
      description: 'Background color',
      table: { category: 'Colors' },
    },
    text_color: {
      control: 'color',
      description: 'Text color',
      table: { category: 'Colors' },
    },
    cta_bg_color: {
      control: 'color',
      description: 'CTA button background',
      table: { category: 'Colors' },
    },
    cta_text_color: {
      control: 'color',
      description: 'CTA button text color',
      table: { category: 'Colors' },
    },
  },
};

export default meta;
type Story = StoryObj<BannerSmallArgs>;

export const Default: Story = {
  args: {
    partner_logo: 'https://picsum.photos/60/60',
    title: 'Special Offer',
    description: 'Get exclusive deals on our products.',
    cta_text: 'Learn More',
    cta_url: '#',
    bg_color: '#f8f9fa',
    text_color: '#212529',
    cta_bg_color: '#007bff',
    cta_text_color: '#ffffff',
  },
};

export const DarkTheme: Story = {
  args: {
    partner_logo: 'https://picsum.photos/60/60',
    title: 'Premium Content',
    description: 'Unlock exclusive features today.',
    cta_text: 'Subscribe',
    cta_url: '#',
    bg_color: '#212529',
    text_color: '#f8f9fa',
    cta_bg_color: '#ffc107',
    cta_text_color: '#212529',
  },
};
