/**
 * Banner Big Module Stories
 *
 * Large promotional banner for native advertising placements.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface BannerBigArgs {
  partner_name: string;
  partner_logo: string;
  title: string;
  subtitle: string;
  cta_text: string;
  cta_url: string;
  main_media: string;
  bg_color: string;
  text_color: string;
  cta_bg_color: string;
  cta_text_color: string;
}

const meta: Meta<BannerBigArgs> = {
  title: 'Modules/Native Placements/Banner Big',
  parameters: {
    docs: {
      description: {
        component: `Large promotional banner for native advertising campaigns.

**Features:**
- Partner branding with logo and name
- Customizable title and subtitle
- Call-to-action button
- Full background image support
- Configurable color scheme via CSS variables
- Optional countdown timer support`,
      },
    },
    twig: {
      template: '_stories/native_placements-banner_big-story.html.twig',
      componentPath: 'module/native_placements/banner_big',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    partner_name: {
      control: 'text',
      description: 'Partner/brand name',
      table: { category: 'Content' },
    },
    partner_logo: {
      control: 'text',
      description: 'Partner logo URL',
      table: { category: 'Content' },
    },
    title: {
      control: 'text',
      description: 'Banner headline',
      table: { category: 'Content' },
    },
    subtitle: {
      control: 'text',
      description: 'Banner description',
      table: { category: 'Content' },
    },
    cta_text: {
      control: 'text',
      description: 'CTA button text',
      table: { category: 'CTA' },
    },
    cta_url: {
      control: 'text',
      description: 'CTA button URL',
      table: { category: 'CTA' },
    },
    main_media: {
      control: 'text',
      description: 'Background image URL',
      table: { category: 'Media' },
    },
    bg_color: {
      control: 'color',
      description: 'Background color',
      table: { category: 'Colors' },
    },
    text_color: {
      control: 'color',
      description: 'Text color',
      table: { category: 'Colors' },
    },
    cta_bg_color: {
      control: 'color',
      description: 'CTA button background',
      table: { category: 'Colors' },
    },
    cta_text_color: {
      control: 'color',
      description: 'CTA button text color',
      table: { category: 'Colors' },
    },
  },
};

export default meta;
type Story = StoryObj<BannerBigArgs>;

export const Default: Story = {
  args: {
    partner_name: 'Partner',
    partner_logo: 'https://picsum.photos/100/40',
    title: 'Big Summer Sale!',
    subtitle: 'Up to 50% off on select products.',
    cta_text: 'Shop Now',
    cta_url: '#',
    main_media: 'https://picsum.photos/800/400',
    bg_color: '#1a1a2e',
    text_color: '#ffffff',
    cta_bg_color: '#e94560',
    cta_text_color: '#ffffff',
  },
};

export const MoviePromo: Story = {
  args: {
    partner_name: 'Cinema Plus',
    partner_logo: 'https://picsum.photos/100/40',
    title: 'New Release: Summer Blockbuster',
    subtitle: 'In theaters now. Get your tickets today!',
    cta_text: 'Book Tickets',
    cta_url: '#',
    main_media: 'https://picsum.photos/800/400',
    bg_color: '#0f0f23',
    text_color: '#ffffff',
    cta_bg_color: '#ffd700',
    cta_text_color: '#000000',
  },
};
