/**
 * Footer Module Stories
 *
 * Main footer component with brand logo, navigation links, social links, and copyright.
 * 
 * This module uses Twig blocks for customization, allowing projects to override
 * logo sections, social links, and navigation links via {% embed %}.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface FooterArgs {
  footer_logo_brand_img_src: string;
  footer_logo_brand_img_alt: string;
  footer_logo_brand_img_width: number;
  footer_logo_brand_img_height: number;
  footer_logo_group_img_src: string;
  footer_logo_group_img_alt: string;
  footer_logo_group_img_width: number;
  footer_logo_group_img_height: number;
  footer_copyright: string;
  footer_all_rights_reserved: string;
}

// Component metadata
const meta: Meta<FooterArgs> = {
  title: 'Modules/Footer',
  parameters: {
    docs: {
      description: {
        component: 'Main footer with brand logo, navigation, social links, and copyright information. Uses blocks for easy customization.',
      },
    },
    twig: {
      template: 'module/footer/footer_main.html.twig',
      renderMode: 'include',
      componentPath: 'module/footer/footer_main',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    footer_logo_brand_img_src: {
      control: 'text',
      description: 'Brand logo image source URL',
      table: { category: 'Brand Logo' },
    },
    footer_logo_brand_img_alt: {
      control: 'text',
      description: 'Brand logo alt text',
      table: { category: 'Brand Logo' },
    },
    footer_logo_brand_img_width: {
      control: 'number',
      description: 'Brand logo width',
      table: { category: 'Brand Logo' },
    },
    footer_logo_brand_img_height: {
      control: 'number',
      description: 'Brand logo height',
      table: { category: 'Brand Logo' },
    },
    footer_logo_group_img_src: {
      control: 'text',
      description: 'Webedia group logo source URL',
      table: { category: 'Group Logo' },
    },
    footer_logo_group_img_alt: {
      control: 'text',
      description: 'Webedia group logo alt text',
      table: { category: 'Group Logo' },
    },
    footer_logo_group_img_width: {
      control: 'number',
      description: 'Group logo width',
      table: { category: 'Group Logo' },
    },
    footer_logo_group_img_height: {
      control: 'number',
      description: 'Group logo height',
      table: { category: 'Group Logo' },
    },
    footer_copyright: {
      control: 'text',
      description: 'Copyright text',
      table: { category: 'Copyright' },
    },
    footer_all_rights_reserved: {
      control: 'text',
      description: 'All rights reserved text',
      table: { category: 'Copyright' },
    },
  },
};

export default meta;
type Story = StoryObj<FooterArgs>;

// Stories
export const Default: Story = {
  args: {
    footer_logo_brand_img_src: 'https://picsum.photos/150/50',
    footer_logo_brand_img_alt: 'Brand Logo',
    footer_logo_brand_img_width: 150,
    footer_logo_brand_img_height: 50,
    footer_logo_group_img_src: 'https://picsum.photos/100/30',
    footer_logo_group_img_alt: 'Webedia',
    footer_logo_group_img_width: 100,
    footer_logo_group_img_height: 30,
    footer_copyright: '© Your Brand Name',
    footer_all_rights_reserved: 'All rights reserved',
  },
};

export const WithLongCopyright: Story = {
  args: {
    ...Default.args,
    footer_copyright: '© Your Brand Name - A Division of Webedia Group',
  },
};

export const WithCustomLogos: Story = {
  args: {
    ...Default.args,
    footer_logo_brand_img_src: 'https://picsum.photos/200/60?random=brand',
    footer_logo_group_img_src: 'https://picsum.photos/120/40?random=group',
  },
};
