/**
 * Cookie Banner Module Stories
 *
 * GDPR/cookie consent banner component.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface CookieBannerArgs {
  banner_headline: string;
  banner_link: string;
  banner_title_link: string;
}

const meta: Meta<CookieBannerArgs> = {
  title: 'Modules/Consent/Cookie Banner',
  parameters: {
    docs: {
      description: {
        component: `Simple cookie consent banner for GDPR compliance.

**Features:**
- Customizable headline text
- Link to privacy policy
- OK button for consent acknowledgment
- Controlled by JavaScript for show/hide behavior`,
      },
    },
    twig: {
      template: '_stories/consent-cookie_banner-story.html.twig',
      componentPath: 'module/consent/cookie_banner',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
  argTypes: {
    banner_headline: {
      control: 'text',
      description: 'Main banner message',
      table: { category: 'Content' },
    },
    banner_link: {
      control: 'text',
      description: 'Privacy policy URL',
      table: { category: 'Content' },
    },
    banner_title_link: {
      control: 'text',
      description: 'Privacy policy link text',
      table: { category: 'Content' },
    },
  },
};

export default meta;
type Story = StoryObj<CookieBannerArgs>;

export const Default: Story = {
  args: {
    banner_headline: 'We use cookies to improve your experience on our site.',
    banner_link: '#privacy-policy',
    banner_title_link: 'Learn more',
  },
};

export const French: Story = {
  args: {
    banner_headline: 'Nous utilisons des cookies pour améliorer votre expérience.',
    banner_link: '#politique-confidentialite',
    banner_title_link: 'En savoir plus',
  },
};
