/**
 * Overlay Anchor Module Stories
 *
 * Mount point for modal overlays and popups.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface OverlayAnchorArgs {}

const meta: Meta<OverlayAnchorArgs> = {
  title: 'Modules/Anchor/Overlay Anchor',
  parameters: {
    docs: {
      description: {
        component: `Mount point element for modal overlays and popup content.

**Purpose:**
This utility module renders a \`<div id="overlay-layer">\` that serves as a mount point for dynamically inserted overlay content like modals, lightboxes, and popups.

**Usage:**
Include once in your base layout, typically near the closing \`</body>\` tag.

\`\`\`twig
{% include '@Ui/module/anchor/overlay_anchor.html.twig' %}
\`\`\``,
      },
    },
    twig: {
      template: '_stories/anchor-overlay_anchor-story.html.twig',
      componentPath: 'module/anchor/overlay_anchor',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
};

export default meta;
type Story = StoryObj<OverlayAnchorArgs>;

export const Default: Story = { args: {} };
