/**
 * MQ State Anchor Module Stories
 *
 * Invisible anchor element for media query state detection.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface MQStateAnchorArgs {}

const meta: Meta<MQStateAnchorArgs> = {
  title: 'Modules/Anchor/MQ State Anchor',
  parameters: {
    docs: {
      description: {
        component: `Invisible anchor element for detecting the current media query breakpoint.

**Purpose:**
This utility module renders a hidden \`<div id="mq-state">\` that JavaScript uses to detect which breakpoint is currently active. The element's computed styles change based on CSS media queries, allowing JS to read the current breakpoint state.

**Usage:**
Include once in your base layout, typically near the closing \`</body>\` tag.

\`\`\`twig
{% include '@Ui/module/anchor/mq_state_anchor.html.twig' %}
\`\`\``,
      },
    },
    twig: {
      template: '_stories/anchor-mq_state_anchor-story.html.twig',
      componentPath: 'module/anchor/mq_state_anchor',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
};

export default meta;
type Story = StoryObj<MQStateAnchorArgs>;

export const Default: Story = { args: {} };
