/**
 * Rectangle Ad Module Stories - Placeholder implementation for Storybook
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface RectangleArgs {
  position: 'atf' | 'btf' | 'sidebar';
  is_sticky?: boolean;
  ad_id: string;
}

const meta: Meta<RectangleArgs> = {
  title: 'Modules/Ads/Rectangle',
  parameters: {
    docs: { description: { component: 'Rectangle ad placeholder with optional sticky positioning. Displays 300x600 placeholder in Storybook.' } },
    twig: { template: 'module/ads/rectangle.html.twig', renderMode: 'include', componentPath: 'module/ads/rectangle', argsToContext: (args) => args },
  } as StoryParameters,
  argTypes: {
    position: { control: 'select', options: ['atf', 'btf', 'sidebar'], description: 'Ad position identifier', table: { category: 'Content' } },
    is_sticky: { control: 'boolean', description: 'Enable sticky positioning', table: { category: 'Layout' } },
    ad_id: { control: 'text', description: 'Ad container ID', table: { category: 'Data' } },
  },
};

export default meta;
type Story = StoryObj<RectangleArgs>;

export const Default: Story = { args: { position: 'atf', is_sticky: false, ad_id: 'rectangle_atf' } };
export const Sticky: Story = { args: { position: 'sidebar', is_sticky: true, ad_id: 'rectangle_sidebar' } };
export const BelowTheFold: Story = { args: { position: 'btf', is_sticky: false, ad_id: 'rectangle_btf' } };
