/**
 * Masthead Ad Module Stories
 *
 * Top-of-page banner ad placeholder.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface MastheadArgs {}

const meta: Meta<MastheadArgs> = {
  title: 'Modules/Ads/Masthead',
  parameters: {
    docs: {
      description: {
        component: `Top-of-page masthead banner ad container.

**Purpose:**
Renders a placeholder container for masthead/billboard ads that typically appear at the very top of the page, above the header.

**Dimensions:**
- Default placeholder: 900x150px
- Actual ad dimensions may vary based on ad server configuration

**Usage:**
\`\`\`twig
{% include '@Ui/module/ads/masthead.html.twig' %}
\`\`\``,
      },
    },
    twig: {
      template: 'module/ads/masthead.html.twig',
      renderMode: 'include',
      componentPath: 'module/ads/masthead',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
};

export default meta;
type Story = StoryObj<MastheadArgs>;

export const Default: Story = { args: {} };
