/**
 * Ad Bait Module Stories
 *
 * Element for adblock detection.
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../../.storybook/types';

interface AdBaitArgs {}

const meta: Meta<AdBaitArgs> = {
  title: 'Modules/Ads/Ad Bait',
  parameters: {
    docs: {
      description: {
        component: `Bait element for detecting if an adblocker is active.

**Purpose:**
This module renders a \`<div class="easyAdsBox">\` element that adblockers typically hide or remove. JavaScript can then check if this element is visible to detect adblock usage.

**How it works:**
1. The element uses class names that adblockers commonly target
2. JavaScript checks if the element exists and is visible
3. If hidden/removed, an adblocker is likely active

**Usage:**
Include once in your base layout.

\`\`\`twig
{% include '@Ui/module/ads/ad_bait.html.twig' %}
\`\`\``,
      },
    },
    twig: {
      template: '_stories/ads-ad_bait-story.html.twig',
      componentPath: 'module/ads/ad_bait',
      argsToContext: (args) => args,
    },
  } as StoryParameters,
};

export default meta;
type Story = StoryObj<AdBaitArgs>;

export const Default: Story = { args: {} };
