/**
 * CTA Subcategory Component Stories
 *
 * Call-to-action link for subcategory navigation, with standard and article variants.
 *
 * Uses the actual @Ui/component/cta_subcategory.html.twig template through a wrapper
 * that includes the template with explicit variables. The component has two modes:
 * standard subcategory and article variant with different styling.
 *
 * Template structure:
 * - cta_subcategory.html.twig expects flat variables (btn_href, btn_title, cta_subcategory_article)
 * - Story wrapper includes template with { ... } only syntax
 * - cta_subcategory_article boolean toggles between standard and article styling
 */

import type { Meta, StoryObj } from '@storybook/react';
import type { StoryParameters } from '../../.storybook/types';

interface CTASubcategoryArgs {
  btn_href: string;
  btn_title: string;
  cta_subcategory_article?: boolean;
}

// Component metadata
const meta: Meta<CTASubcategoryArgs> = {
  title: 'Components/CTA Subcategory',
  parameters: {
    docs: {
      description: {
        component:
          'Call-to-action link for subcategory navigation, with standard and article variants.',
      },
    },
    twig: {
      template: 'component/cta_subcategory.html.twig',
      renderMode: 'include',
      componentPath: 'cta_subcategory',
    },
  } as StoryParameters,
  argTypes: {
    // Core
    btn_href: {
      control: 'text',
      description: 'Link URL (required)',
      table: { category: 'Core' },
    },
    btn_title: {
      control: 'text',
      description: 'Link text (required)',
      table: { category: 'Core' },
    },
    // Visual
    cta_subcategory_article: {
      control: 'boolean',
      description: 'Use article variant styling',
      table: { category: 'Visual' },
    },
  },
};

export default meta;
type Story = StoryObj<CTASubcategoryArgs>;

// Playground: All controls available, minimal defaults
export const Playground: Story = {
  args: {
    btn_href: '#category',
    btn_title: 'View Category',
  },
};

// Standard subcategory CTA
export const Standard: Story = {
  args: {
    btn_href: '#tech',
    btn_title: 'Technology',
    cta_subcategory_article: false,
  },
};

// Article variant with different styling
export const ArticleVariant: Story = {
  args: {
    btn_href: '#article',
    btn_title: 'Read More Articles',
    cta_subcategory_article: true,
  },
};
