/**
 * Introduction Page
 *
 * Getting started guide for UI-Bundle Component Documentation.
 * This page explains the php-wasm Twig rendering approach and how to use components.
 */

import type { Meta, StoryObj } from '@storybook/react';
import React from 'react';

const meta: Meta = {
  title: 'Introduction',
  parameters: {
    docs: {
      description: {
        component:
          'Getting started guide for UI-Bundle component documentation.',
      },
    },
    // Disable controls for documentation page
    controls: { disable: true },
    // Disable actions for documentation page
    actions: { disable: true },
  },
};

export default meta;
type Story = StoryObj;

// Main documentation page
export const GettingStarted: Story = {
  render: () => {
    const html = `
      <div style="font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; max-width: 800px; padding: 20px; line-height: 1.6;">
        <h1 style="border-bottom: 1px solid #eee; padding-bottom: 10px;">UI-Bundle Component Documentation</h1>

        <p>Interactive documentation for UI-Bundle's Twig components, powered by <strong>php-wasm</strong> for exact PHP Twig rendering in the browser.</p>

        <h2>How It Works</h2>

        <p>Unlike typical Storybook setups, this documentation runs <strong>actual PHP Twig</strong> in your browser:</p>

        <ol>
          <li><strong>php-wasm</strong> compiles PHP 8.1 to WebAssembly</li>
          <li><strong>Twig 3.x</strong> renders templates exactly as in production</li>
          <li><strong>Symfony Twig Bridge</strong> provides familiar functions and filters</li>
          <li><strong>UiExtension</strong> functions work with mocked services</li>
        </ol>

        <p>This means what you see here matches what renders in production - no Twig.js approximations.</p>

        <h2>Using Components</h2>

        <h3>In Twig Templates</h3>

        <p><strong>Macro-based components</strong> (Button, Label, Thumbnail):</p>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><code>{% from '@Ui/component/button.html.twig' import button %}

{{ button({ text: 'Click me', type: 'primary' }) }}</code></pre>

        <p><strong>Include-based components</strong> (Title, Subtitle, Share):</p>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><code>{% include '@Ui/component/title.html.twig' with {
    title_text: 'Section Title',
    title_markup: 'h2'
} only %}</code></pre>

        <h3>Using Modules</h3>

        <p><strong>Include-based modules</strong> (Pagination, Footer, Dropdown, Video Card):</p>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><code>{% include '@Ui/module/pagination/pagination.html.twig' with {
    pagination: pagination_object
} only %}</code></pre>

        <h3>Using Sections</h3>

        <p><strong>Extend-based sections</strong> (Grid Layout, Roller Layout):</p>
        <pre style="background: #f5f5f5; padding: 15px; border-radius: 4px; overflow-x: auto;"><code>{% extends '@Ui/section/dynamic_content/layout_grid_simple.html.twig' %}

{% block item %}
    &lt;article&gt;{{ item.title }}&lt;/article&gt;
{% endblock %}</code></pre>

        <h3>Source Viewer</h3>

        <p>Each story includes a <strong>Source</strong> panel (in the addons bar below) with:</p>
        <ul>
          <li><strong>Twig Usage</strong> - Copy-paste ready code for your templates</li>
          <li><strong>HTML Output</strong> - The actual rendered markup</li>
        </ul>

        <h2>Component Tiers</h2>

        <p>UI-Bundle organizes templates in three tiers, all available in Storybook:</p>

        <table style="border-collapse: collapse; width: 100%; margin: 15px 0;">
          <thead>
            <tr style="background: #f5f5f5;">
              <th style="border: 1px solid #ddd; padding: 10px; text-align: left;">Tier</th>
              <th style="border: 1px solid #ddd; padding: 10px; text-align: left;">Purpose</th>
              <th style="border: 1px solid #ddd; padding: 10px; text-align: left;">Examples</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="border: 1px solid #ddd; padding: 10px;"><strong>Components</strong></td>
              <td style="border: 1px solid #ddd; padding: 10px;">Atomic building blocks</td>
              <td style="border: 1px solid #ddd; padding: 10px;">Button, Label, Title</td>
            </tr>
            <tr>
              <td style="border: 1px solid #ddd; padding: 10px;"><strong>Modules</strong></td>
              <td style="border: 1px solid #ddd; padding: 10px;">Feature compositions</td>
              <td style="border: 1px solid #ddd; padding: 10px;">Pagination, Footer, Dropdown, Video Card</td>
            </tr>
            <tr>
              <td style="border: 1px solid #ddd; padding: 10px;"><strong>Sections</strong></td>
              <td style="border: 1px solid #ddd; padding: 10px;">Page layouts</td>
              <td style="border: 1px solid #ddd; padding: 10px;">Grid Layout, Roller Layout</td>
            </tr>
          </tbody>
        </table>

        <h2>Getting Help</h2>

        <ul>
          <li>Check the <strong>Controls</strong> panel to experiment with props</li>
          <li>View <strong>Unsupported Functions</strong> panel for mock limitations</li>
          <li>Browse <strong>Modules</strong> for feature-level components (Pagination, Footer, etc.)</li>
          <li>Explore <strong>Sections</strong> for page layout templates (Grid, Roller, etc.)</li>
          <li>Source code: <code style="background: #f5f5f5; padding: 2px 6px; border-radius: 3px;">templates/component/*.html.twig</code>, <code style="background: #f5f5f5; padding: 2px 6px; border-radius: 3px;">templates/module/*.html.twig</code>, <code style="background: #f5f5f5; padding: 2px 6px; border-radius: 3px;">templates/section/*.html.twig</code></li>
        </ul>
      </div>
    `;
    return React.createElement('div', { dangerouslySetInnerHTML: { __html: html } });
  },
};
