/**
 * Storybook addon registration for unsupported functions panel.
 *
 * This addon displays a panel showing Twig functions that were called
 * during rendering but are not yet mocked in the Storybook environment.
 * Helps developers identify which Symfony functions need mocking.
 */
import { addons, types } from 'storybook/manager-api';
import { UnsupportedFunctionsPanel } from './manager.js';

const ADDON_ID = 'unsupported-functions';
const PANEL_ID = `${ADDON_ID}/panel`;

addons.register(ADDON_ID, () => {
  addons.add(PANEL_ID, {
    type: types.PANEL,
    title: 'Unsupported Functions',
    match: ({ viewMode }) => viewMode === 'story',
    render: UnsupportedFunctionsPanel,
  });
});
