/**
 * Storybook addon registration for Source Viewer panel.
 *
 * This addon displays Twig usage examples and rendered HTML output
 * for each story. Helps developers copy working code snippets
 * for use in their projects.
 */
import { addons, types } from 'storybook/manager-api';
import { SourceViewerPanel } from './SourceViewerPanel.js';

export const ADDON_ID = 'source-viewer';
const PANEL_ID = `${ADDON_ID}/panel`;

addons.register(ADDON_ID, () => {
  addons.add(PANEL_ID, {
    type: types.PANEL,
    title: 'Source',
    match: ({ viewMode }) => viewMode === 'story',
    render: SourceViewerPanel,
  });
});
