# Storybook Troubleshooting Guide

## Common Issues

### Template Not Found Errors

If you see errors like:
```
Twig Error: Unable to find template "_stories/xxx-story.html.twig" (looked into: /templates).
```

This typically happens when:
1. The ZIP bundles are outdated or missing
2. Your browser has cached an old version
3. New templates were added but the Vite plugin hasn't rebuilt the ZIPs

**Solution:**

1. **Restart Storybook** (the Vite plugin rebuilds ZIPs automatically on startup):
   ```bash
   # Stop the current process (Ctrl+C), then:
   pnpm run storybook
   ```

2. **Clear browser cache and hard reload:**
   - Chrome/Edge: `Ctrl+Shift+R` (Windows/Linux) or `Cmd+Shift+R` (Mac)
   - Firefox: `Ctrl+F5` (Windows/Linux) or `Cmd+Shift+R` (Mac)
   - Safari: `Cmd+Option+R` (Mac)

### How It Works

Storybook uses PHP-WASM to render real Twig templates in the browser. On boot, two ZIP files are extracted into the virtual filesystem:

| File | Contents |
|------|----------|
| `.storybook/public/vendor.zip` | Twig engine, Symfony components, KnpMenu, mock extensions |
| `.storybook/public/templates.zip` | All `.twig` files from `templates/` |

These ZIPs are generated automatically by the `vite-twig-zipper` Vite plugin, which also watches for `.twig` file changes during development and rebuilds `templates.zip` on the fly.

### When Do ZIPs Rebuild?

| Change | Auto-rebuild? |
|--------|--------------|
| Edit a `.twig` template | Yes (hot reload via Vite plugin) |
| Add a new `.twig` template | Yes |
| Edit PHP mocks in `.storybook/mocks/` | No - restart Storybook |
| Run `composer update` | No - restart Storybook |

### Debug Information

The enhanced error messages include filesystem debug info when a template is not found. Click the "Filesystem Debug Info" section in the error overlay to see:

- Whether the file exists in the virtual filesystem
- What files are in the template directory
- Troubleshooting steps

## Performance Notes

- **Boot time**: 200-500ms for first story load (extracts ZIPs to virtual filesystem)
- **Render time**: 10-50ms per story after boot

The PHP-WASM instance is cached after boot, so subsequent story renders are fast.

## Additional Help

If you're still experiencing issues:

1. Check the browser console for detailed error messages
2. Verify the ZIP files exist: `ls -la .storybook/public/*.zip`
3. Try in incognito/private mode to rule out cache issues
4. Delete `.storybook/public/*.zip` and restart Storybook to force a full rebuild
