# Section Templates Catalog

Section templates in `templates/section/dynamic_content/` provide page-level layout patterns.

## base_layout.html.twig

Base template for all section layouts. Extended by the others, not used directly.

- **Blocks**: `section_title`, `section_content`, `section_cta`
- **Key variables**: `is_big_section` (bool), `section_classes` (array), `has_cta`/`cta_href`/`cta_text`, plus all `@Ui/component/title.html.twig` variables

---

## layout_2_cols_ads.html.twig

Two-column layout: left content column + right sticky ad column.

- **Extends**: `base_layout.html.twig`
- **Blocks**: `section_title_left`, `item` (inside `for` loop over `entities`)
- **Key variables**: `entities` (array), `gap_size` (string, default "20"), `left_col_classes`/`right_col_classes` (arrays)
- **Grid**: `.gd-2-cols > .left-col + .right-col`

```twig
{% embed '@Ui/section/dynamic_content/layout_2_cols_ads.html.twig' with {
    title_text: 'Latest', entities: articles
} %}
    {% block item %}
        {% include '@Ui/module/news_cards/news_card_base.html.twig' with { title: item.title } only %}
    {% endblock %}
{% endembed %}
```

---

## layout_grid_simple.html.twig

Responsive grid (1 col mobile, 2 cols tablet, configurable desktop).

- **Extends**: `base_layout.html.twig`
- **Blocks**: `banner`, `item`
- **Key variables**: `entities` (array), `gap_size` (string, default "20"), `gd_l_number` (string, default "4" desktop cols)

---

## layout_roller.html.twig

Horizontal scrolling carousel using the roller module.

- **Extends**: `base_layout.html.twig`
- **Blocks**: `slider` (inside roller embed)
- **Key variables**: `entities` (array), `block_path` (path to block defining `item`)
- **Embeds**: `@Ui/module/roller/roller.html.twig`

---

## layout_roller_big.html.twig

Grouped roller -- batches items into pages inside a carousel.

- **Extends**: `base_layout.html.twig`
- **Key variables**: `entities` (array), `batch_number` (int, default 3), `gap_size` (string, default "20"), `block_path`

---

## layout_single_item_left.html.twig

Featured item on the left, list of items on the right. Max 7 items.

- **Extends**: `base_layout.html.twig`
- **Blocks**: `item_left` (first entity), `item_right` (entities 2-7)
- **Key variables**: `entities` (array, max 7), `img_ratio` (auto-computed based on count)
