# SCSS Integration Reference

## Import Order (CRITICAL)

```scss
@use "sass:math";

// 1. Project theme declarations (MUST come before default_variables)
@import 'project_theme_config';

// 2. UI Bundle defaults (uses global-variable-exists() to conditionally set)
@import '@Ui/scss/config/default_variables';

// 3. Project overrides
@import 'project_extend_variables';

// 4. Helpers
@import "@Ui/scss/helpers/mixin/_import";
@import "@Ui/scss/helpers/extend/_import";
@import "@Ui/scss/helpers/partial/_import";

// 5. Components (import only what you use)
@import '@Ui/scss/component/button';
@import '@Ui/scss/component/label';
@import '@Ui/scss/component/thumbnail';
@import '@Ui/scss/component/title';
@import '@Ui/scss/component/subtitle';
@import '@Ui/scss/component/share';
@import '@Ui/scss/component/cta_subcategory';

// 6. Modules (import only what you use)
@import '@Ui/scss/module/header_main_v2';
@import '@Ui/scss/module/breadcrumb';
@import '@Ui/scss/module/news_card_base';
// ... etc

// 7. Layouts
@import '@Ui/scss/layout/grid';
@import '@Ui/scss/layout/grid_2_cols';
@import '@Ui/scss/layout/website_layout';
```

## Available SCSS Files

### Config
- `config/default_variables` - All theme variables
- `config/icon_config` - Icon font config

### Helpers
- `helpers/mixin/_import` - All mixins (media queries, grid, dom, px2rem, truncate)
- `helpers/extend/_import` - Placeholder extends
- `helpers/partial/_import` - Normalize + partials

### Components
`component/button`, `component/label`, `component/thumbnail`, `component/title`, `component/subtitle`, `component/share`, `component/cta_subcategory`

### Modules
`module/ads`, `module/article/article_headline`, `module/article/article_title`, `module/audion_reader`, `module/authorpage/author_biography`, `module/authorpage/author_description`, `module/bottom_bar`, `module/breadcrumb`, `module/cookie_banner`, `module/directory_alpha`, `module/dropdown`, `module/footer/footer_main`, `module/header_main_v2`, `module/header_min`, `module/link_bar`, `module/native_placements/banner`, `module/native_placements/banner_small`, `module/native_placements/player_footer`, `module/news_card_base`, `module/offer_card_base`, `module/pagination/pagination`, `module/pagination/pagination_bis`, `module/player`, `module/player_pip`, `module/right_column`, `module/roller`, `module/search_form`, `module/subnav`, `module/video_card`

### Layouts
`layout/grid`, `layout/grid_2_cols`, `layout/website_layout`

---

## Media Query Mixins

```scss
// Min-width breakpoint
@include mq("medium") { /* >= 1016px */ }

// Target specific range
@include target-mq("zero", "small") { /* 0-600px */ }
```

### Breakpoints
| Name | Value |
|------|-------|
| `"zero"` | 0 |
| `"small"` | 600px |
| `"medium"` | 1016px |
| `"large"` | 1276px |

---

## Grid System

```scss
.gd             // display: grid
.gd-gap-{n}     // grid-gap: {n}px (n: 10, 15, 20, 25, 30)
.gd-gapless     // no gap
.gd-s-{1-6}     // columns at "zero" breakpoint
.gd-m-{1-6}     // columns at "small" breakpoint
.gd-l-{1-6}     // columns at "medium" breakpoint
.gd-xl-{1-6}    // columns at "large" breakpoint
.gd-2-cols      // two-column layout (1fr + 22.1875rem at medium+)
```

---

## Placeholder Extends

```scss
%full-link          // Pseudo-element covering parent (position: absolute overlay)
%btn-layout-remover // Reset button styles (border: none, background: none, padding: 0)
%skin-css-fixes     // position: relative
```

---

## Key Theme Variables

Override these in your `project_theme_config.scss` (BEFORE `default_variables`):

| Variable | Values | Default |
|----------|--------|---------|
| `$website-direction` | `"ltr"`, `"rtl"` | `"ltr"` |
| `$website-header-version` | `"v1"`, `"v2"` | `"v1"` |
| `$website-radius-theme` | `"pepper"`, `"smoothy"`, `"dolce"`, `"honey"` | `"pepper"` |
| `$website-grayscale-theme` | `"deepblue"`, `"onyx"` | `"deepblue"` |
| `$website-icon-theme` | `"rounded"`, `"sharp"` | `"rounded"` |
| `$primary-color` | any color | `#0066cc` |
| `$font-style1` | font family | system fonts |
| `$font-style2` | font family | system fonts |

### Extending Styles

To override a UI Bundle SCSS file, create `extend_{name}.scss` in your project:
```
project/scss/extend_button.scss    // overrides @Ui/scss/component/button
project/scss/extend_header.scss    // overrides @Ui/scss/module/header_main_v2
```
