# Module Catalog

39 module templates across 17 domains in `templates/module/`.

## Table of Contents

- [Ads](#ads) - ad_bait, masthead, rectangle
- [Anchor](#anchor) - mq_state_anchor, overlay_anchor
- [Article](#article) - article_headline, article_title
- [Author](#author) - author_biography, author_description
- [Breadcrumb](#breadcrumb) - breadcrumb
- [C2C](#c2c) - offer_card_base
- [Consent](#consent) - cookie_banner
- [Directory](#directory) - directory_alpha
- [Dropdown](#dropdown) - dropdown
- [Footer](#footer) - footer_main
- [Header](#header) - header_main_v2, knp_menu, raw_menu
- [Native Placements](#native-placements) - banner_big, banner_small, player_footer
- [Nav](#nav) - link_bar, subnav
- [News Cards](#news-cards) - news_card_base
- [Pagination](#pagination) - pagination, pagination_bis
- [Player](#player) - player_card, player_external, player_internal, player_internal_yt
- [Player Audion](#player-audion) - audion_reader
- [Roller](#roller) - roller
- [Search](#search) - search
- [Video](#video) - video_card

---

## Ads

### ad_bait
- **Template**: `@Ui/module/ads/ad_bait.html.twig`
- **SCSS**: `@Ui/scss/module/ads`
- **JS**: `@Ui/js/module/advertising/utils`
- **Key vars**: none (static adblock detection div)
- **Usage**: `{% include '@Ui/module/ads/ad_bait.html.twig' %}`

### masthead
- **Template**: `@Ui/module/ads/masthead.html.twig`
- **SCSS**: `@Ui/scss/module/ads`
- **Key vars**: none (static placeholder)

### rectangle
- **Template**: `@Ui/module/ads/rectangle.html.twig`
- **SCSS**: `@Ui/scss/module/ads`
- **Key vars**: `is_sticky` (bool), `position` (string, placement id), `ad_id` (string, DOM id)
- **Usage**: `{% include '@Ui/module/ads/rectangle.html.twig' with { position: 'right', is_sticky: true } %}`

---

## Anchor

### mq_state_anchor
- **Template**: `@Ui/module/anchor/mq_state_anchor.html.twig`
- **Key vars**: none (static `#mq-state` div for media query JS detection)

### overlay_anchor
- **Template**: `@Ui/module/anchor/overlay_anchor.html.twig`
- **JS**: `@Ui/js/module/overlay/index`
- **Key vars**: none (static `#overlay-layer` div)

---

## Article

### article_headline
- **Template**: `@Ui/module/article/article_headline.html.twig`
- **SCSS**: `@Ui/scss/module/article/article_headline`
- **Key vars**: `articlePage_headline` (string|html), `classes` (array)
- **Usage**: `{% include '@Ui/module/article/article_headline.html.twig' with { articlePage_headline: '<p>...</p>' } %}`

### article_title
- **Template**: `@Ui/module/article/article_title.html.twig`
- **SCSS**: `@Ui/scss/module/article/article_title`
- **Key vars**: `article_title` (string), `published_date` (datetime), `updated_date` (datetime), `label` (array of label objects), `share` (string, wording)
- **Usage**: `{% include '@Ui/module/article/article_title.html.twig' with { article_title: 'My Article', published_date: date } only %}`

---

## Author

### author_biography
- **Template**: `@Ui/module/author/author_biography.html.twig`
- **SCSS**: `@Ui/scss/module/authorpage/author_biography`
- **Key vars**: `type` (string, e.g. "author-article-short-bio"), `author_name` (string), `author_img` (string), `author_link` (string), `author_bio` (html)

### author_description
- **Template**: `@Ui/module/author/author_description.html.twig`
- **SCSS**: `@Ui/scss/module/authorpage/author_description`
- **Key vars**: `author_name` (string), `author_img` (string), `author_job` (string), `author_hasSocialUrls` (bool), `author_x_url` (string)

---

## Breadcrumb

### breadcrumb
- **Template**: `@Ui/module/breadcrumb/breadcrumb.html.twig`
- **SCSS**: `@Ui/scss/module/breadcrumb`
- **Key vars**: `seo_breadcrumb` (html, rendered breadcrumb), `seo_h1_title` (html, page h1), `aria_level` (string, default "1")
- **Usage**: `{% include '@Ui/module/breadcrumb/breadcrumb.html.twig' with { seo_breadcrumb: html, seo_h1_title: 'Title' } only %}`

---

## C2C

### offer_card_base
- **Template**: `@Ui/module/c2c/offer_card_base.html.twig`
- **SCSS**: `@Ui/scss/module/offer_card_base`
- **Key vars**: `name` (string), `price` (string), `url` (string), `cta` (string), `image` (string)

---

## Consent

### cookie_banner
- **Template**: `@Ui/module/consent/cookie_banner.html.twig`
- **SCSS**: `@Ui/scss/module/cookie_banner`
- **JS**: `@Ui/js/consent/cookieBanner`
- **Key vars**: `banner_headline` (string), `banner_link` (string, privacy URL), `banner_title_link` (string)

---

## Directory

### directory_alpha
- **Template**: `@Ui/module/directory/directory_alpha.html.twig`
- **SCSS**: `@Ui/scss/module/directory_alpha`
- **Key vars**: `letter_directory` (string), `entities_directory` (array), `title_markup` (string), `cta_all_enable` (bool), `cta_all_txt` (string)
- **Usage**: `{% embed '@Ui/module/directory/directory_alpha.html.twig' with { letter_directory: 'A', entities_directory: items } %}`

---

## Dropdown

### dropdown
- **Template**: `@Ui/module/dropdown/dropdown.html.twig`
- **SCSS**: `@Ui/scss/module/dropdown`
- **Key vars**: `cta_text` (string, button label), `data` (array, items), `already_filtered` (bool), `default_path` (string), `value_key` (string)

---

## Footer

### footer_main
- **Template**: `@Ui/module/footer/footer_main.html.twig`
- **SCSS**: `@Ui/scss/module/footer/footer_main`
- **Key vars**: `footer_logo_brand_img_src` (string), `footer_logo_group_img_src` (string), `footer_copyright` (string), `footer_all_rights_reserved` (string)
- **Usage**: `{% embed '@Ui/module/footer/footer_main.html.twig' with { footer_copyright: 'My Site' } %}`

---

## Header

### header_main_v2
- **Template**: `@Ui/module/header/header_main_v2.html.twig`
- **SCSS**: `@Ui/scss/module/header_main_v2`
- **JS**: `@Ui/js/module/header/index`
- **Key vars**: `logo_src` (string), `logo_path` (string, home URL), `menu_obj` (array, nav items), `search_path` (string), `menu_xhr_path` (string, lazy subnav endpoint)
- **Usage**: `{% include '@Ui/module/header/header_main_v2.html.twig' with { logo_src: '/logo.svg', logo_path: '/', menu_obj: menu } only %}`

### knp_menu
- **Template**: `@Ui/module/header/menu/knp_menu.html.twig`
- **Key vars**: KnpMenu item tree
- **Usage**: `{{ knp_menu_render(menu, {template: '@Ui/module/header/menu/knp_menu.html.twig'}) }}`

### raw_menu
- **Template**: `@Ui/module/header/menu/raw_menu.html.twig`
- **Key vars**: `menu_obj` (array), `menu_xhr_path` (string), `menu_has_subnav_html` (bool)

---

## Native Placements

### banner_big
- **Template**: `@Ui/module/native_placements/banner_big.html.twig`
- **SCSS**: `@Ui/scss/module/native_placements/banner`
- **JS**: `@Ui/js/module/nativePlacements/bannerCountdown`
- **Key vars**: `native_banner_obj` (object: partner_name, title, subtitle, cta, url, main_media, colors, pages)

### banner_small
- **Template**: `@Ui/module/native_placements/banner_small.html.twig`
- **SCSS**: `@Ui/scss/module/native_placements/banner_small`
- **Key vars**: `native_banner_small_obj` (object: partner_logo, title, description, cta, url, colors)

### player_footer
- **Template**: `@Ui/module/native_placements/player_footer.html.twig`
- **SCSS**: `@Ui/scss/module/native_placements/player_footer`
- **JS**: `@Ui/js/module/nativePlacements/trackingPlayer`
- **Key vars**: `player_id` (string), `video_id` (string), `title` (string), `campaign_id` (string)

---

## Nav

### link_bar
- **Template**: `@Ui/module/nav/link_bar.html.twig`
- **SCSS**: `@Ui/scss/module/link_bar`
- **Key vars**: `link_bar` (array of items with label/url/route_name), `link_bar_classes` (array)
- **Usage**: `{% include '@Ui/module/nav/link_bar.html.twig' with { link_bar: links } only %}`

### subnav
- **Template**: `@Ui/module/nav/subnav.html.twig`
- **SCSS**: `@Ui/scss/module/subnav`
- **Key vars**: block `subnav_items` (html), `no_nav` (bool), `offset` (int)
- **Usage**: `{% embed '@Ui/module/nav/subnav.html.twig' %}{% block subnav_items %}<a>...</a>{% endblock %}{% endembed %}`

---

## News Cards

### news_card_base
- **Template**: `@Ui/module/news_cards/news_card_base.html.twig`
- **SCSS**: `@Ui/scss/module/news_card_base`
- **Key vars**: `title` (string), `img_src` (string), `base_link` (string), `type` ("col"|"row"|"full"|"text"), `img_ratio` ("16:9"|"1:1"|"3:4"|"banner")
- **Usage**: `{% include '@Ui/module/news_cards/news_card_base.html.twig' with { title: 'News', img_src: '...', base_link: '/article', type: 'col' } only %}`

---

## Pagination

### pagination
- **Template**: `@Ui/module/pagination/pagination.html.twig`
- **SCSS**: `@Ui/scss/module/pagination/pagination`
- **Key vars**: `pagination` (object: getPageCount, pages, currentPage, firstPage, lastPage, previousPage, nextPage)

### pagination_bis
- **Template**: `@Ui/module/pagination/pagination_bis.html.twig`
- **SCSS**: `@Ui/scss/module/pagination/pagination_bis`
- **Key vars**: `pagination_library` (array, page numbers), `pagination_current` (int), `pagination_filter` (array, disabled pages)
- **Usage**: `{% embed '@Ui/module/pagination/pagination_bis.html.twig' with { pagination_library: range(1,10), pagination_current: 3 } %}`

---

## Player

### player_card
- **Template**: `@Ui/module/player/player_card.html.twig`
- **SCSS**: `@Ui/scss/module/player`
- **JS**: `@Ui/js/module/player/index`
- **Key vars**: `video_id` (string, DM id), `player_id` (string, DM player id), `is_main_media` (bool), `iframe_src` (string), `player_thumbnail` (string)

### player_external
- **Template**: `@Ui/module/player/player_external.html.twig`
- **Key vars**: `iframe_src` (string), `iframe_title` (string), `autoplay` (string), `allowfullscreen` (string)

### player_internal
- **Template**: `@Ui/module/player/player_internal.html.twig`
- **JS**: `@Ui/js/module/player/index`
- **Key vars**: `video_id` (string), `player_id` (string), `playlist_id` (string), `player_thumbnail` (string), `player_position` (string)

### player_internal_yt
- **Template**: `@Ui/module/player/player_internal_yt.html.twig`
- **JS**: `@Ui/js/module/player/yt`
- **Key vars**: `video_id` (string, YouTube id), `player_thumbnail` (string), `is_main_media` (bool)

---

## Player Audion

### audion_reader
- **Template**: `@Ui/module/player_audion/audion_reader.html.twig`
- **SCSS**: `@Ui/scss/module/audion_reader`
- **JS**: `@Ui/js/module/playerAudion/audionReader`
- **Key vars**: `audion_reader_url` (string, podcast embed URL)

---

## Roller

### roller
- **Template**: `@Ui/module/roller/roller.html.twig`
- **SCSS**: `@Ui/scss/module/roller`
- **JS**: `@Ui/js/module/roller/index`
- **Key vars**: `classes` (array), `no_nav` (bool), `offset` (int, default 15), `icon_left` (string), `icon_right` (string)
- **Usage**: `{% embed '@Ui/module/roller/roller.html.twig' with { classes: ['my-roller'] } %}{% block slider %}<div class="roller-item">...</div>{% endblock %}{% endembed %}`

---

## Search

### search
- **Template**: `@Ui/module/search/search.html.twig`
- **SCSS**: `@Ui/scss/module/search_form`
- **JS**: `@Ui/js/module/search/index`
- **Key vars**: `search_path` (string, form action), `place_holder` (string), `search_method` (string, "post"|"get"), `search_input_name` (string, default "q")
- **Usage**: `{% include '@Ui/module/search/search.html.twig' with { search_path: '/search', place_holder: 'Search...' } only %}`

---

## Video

### video_card
- **Template**: `@Ui/module/video/video_card.html.twig`
- **SCSS**: `@Ui/scss/module/video_card`
- **JS**: `@Ui/js/module/videoCard/index`
- **Key vars**: `video_title` (string), `video_thumb` (string), `video_id` (string), `video_link` (string), `is_short` (bool)
- **Usage**: `{% include '@Ui/module/video/video_card.html.twig' with { video_title: 'My Video', video_thumb: '...', video_id: 'x123' } only %}`
