# Component Catalog

8 atomic components in `templates/component/`. Components use either **macro** or **include** pattern.

## Table of Contents

- [button](#button) (macro)
- [label](#label) (macro)
- [thumbnail](#thumbnail) (macro)
- [data_attributes](#data_attributes) (macro)
- [title](#title) (include)
- [subtitle](#subtitle) (include)
- [share](#share) (include)
- [cta_subcategory](#cta_subcategory) (include)

---

## button

- **Template**: `@Ui/component/button.html.twig`
- **Pattern**: macro
- **SCSS**: `@Ui/scss/component/button`

### Macros

**`button(button_obj)`** - Single button

| Property | Type | Default | Description |
|----------|------|---------|-------------|
| text | string | required | Button label (wrapped in `<span>`) |
| href | string | null | URL (renders `<a>` if set, `<span>` if not) |
| size | `'sm'`\|`'md'`\|`'lg'` | none | Size modifier class |
| type | string | null | Type modifier (adds `btn-type-{value}`) |
| icon | string | undefined | Icon name (adds `<i class="ui-icons">`) |
| color | string | null | Text color modifier (`btn-color-{value}`) |
| background | string | null | Background modifier (`btn-bg-{value}`) |
| classes | string[] | [] | Extra CSS classes |
| markup | string | `'a'`/`'span'` | HTML element (auto: `a` if href, `span` otherwise) |
| data | object | {} | Data attributes (passed to `dataAttributes()`) |

**`button_with_container(buttons_config)`** - Multiple buttons in a container

| Property | Type | Description |
|----------|------|-------------|
| buttons_config.buttons | button_obj[] | Array of button objects |
| buttons_config.position | string | Alignment class (`btn-holder-{value}`) |

### Usage

```twig
{% from "@Ui/component/button.html.twig" import button %}

{{ button({
    text: 'Subscribe',
    size: 'lg',
    href: '/subscribe',
    icon: 'newsletter'
}) }}
```

---

## label

- **Template**: `@Ui/component/label.html.twig`
- **Pattern**: macro
- **SCSS**: `@Ui/scss/component/label`

### Macro: `label(obj)`

| Property | Type | Default | Description |
|----------|------|---------|-------------|
| value | string | required | Label text (or HTML rendered raw) |
| type | string | null | Type modifier (`label-type-{value}`), overrides color/background |
| color | string | null | Color modifier (`label-color-{value}`) |
| background | string | null | Background modifier (`label-background-{value}`) |
| size | string | null | Size modifier (`label-{value}`) |
| classes | string[] | [] | Extra CSS classes |
| has_content_holder | bool | false | Wraps text in `<span class="label-content">` |

> `text` and `content` are deprecated aliases for `value` and `has_content_holder`.

### Usage

```twig
{% from "@Ui/component/label.html.twig" import label %}

{{ label({ value: 'Breaking News', type: 'breaking', size: 'sm' }) }}
```

---

## thumbnail

- **Template**: `@Ui/component/thumbnail.html.twig`
- **Pattern**: macro
- **SCSS**: `@Ui/scss/component/thumbnail`

### Macro: `thumb(obj)`

Main thumbnail component with optional link, labels, and play icon.

| Property | Type | Default | Description |
|----------|------|---------|-------------|
| picture | string | required | Image src URL |
| alt | string | null | Image alt text |
| width | number | null | Image width |
| height | number | null | Image height |
| ratio | `'3:4'`\|`'16:9'`\|`'1:1'` | none | Aspect ratio class |
| href | string | null | Link wrapping the thumbnail |
| target | string | null | Link target |
| lazyload | bool | false | Adds `loading="lazy"` |
| play | bool | false | Shows play icon overlay |
| cover | bool | true | Adds `thumbnail-cover` class |
| label | object[] | null | Array of label objects (see label component) |
| figcaption | string | null | Figcaption text |
| figure_classes | string[] | [] | Extra figure CSS classes |
| img_classes | string[] | [] | Extra img CSS classes |
| src_obj | object | null | Responsive sources for `<picture>` tag |
| vw_obj | object | `{large,medium,small}` | Viewport widths for picture sources |
| data_attributes_link | object | {} | Data attributes for the link |
| data_attributes_img | object | {} | Data attributes for the img |

### Macro: `img(obj)`

Standalone image (also used internally by `thumb()`). Same img-related props as above.

### Usage

```twig
{% from "@Ui/component/thumbnail.html.twig" import thumb %}

{{ thumb({
    picture: '/images/photo.jpg',
    alt: 'Article photo',
    ratio: '16:9',
    lazyload: true,
    href: '/article/123',
    label: [{ value: 'Video', type: 'video' }],
    play: true
}) }}
```

---

## data_attributes

- **Template**: `@Ui/component/data_attributes.html.twig`
- **Pattern**: macro (utility)

### Macro: `dataAttributes(data_attributes_obj)`

Renders key-value pairs as HTML data attributes. Auto-JSON-encodes `data-jan` values.

| Property | Type | Description |
|----------|------|-------------|
| data_attributes_obj | object | `{ 'data-key': 'value', ... }` |

### Usage

```twig
{% from "@Ui/component/data_attributes.html.twig" import dataAttributes %}

<div {{ dataAttributes({ 'data-tracking': 'click', 'data-jan': { event: 'view' } }) }}>
```

---

## title

- **Template**: `@Ui/component/title.html.twig`
- **Pattern**: include
- **SCSS**: `@Ui/scss/component/title`

### Variables

| Variable | Type | Default | Description |
|----------|------|---------|-------------|
| title_text | string | required | Title text (renders nothing if empty) |
| type_page | bool | false | Page title style vs section title style |
| title_markup | string | `'div'` | HTML tag (`'h1'`-`'h6'` for headings, `'div'` otherwise) |
| title_link | string | null | Wraps title in `<a>` |
| subtitle_text | string | null | Optional subtitle below title |
| title_uppercase | bool | false | Uppercase modifier class |
| title_text_w_roller | bool | false | Modifier for titles next to rollers |
| title_logo | object | null | Logo object: `{ src, width, height, alt }` |
| title_container_id | string | null | HTML id on the container |
| title_container_classes | string[] | [] | Extra container classes |
| title_text_classes | string[] | [] | Extra text classes |
| title_subtext_classes | string[] | [] | Extra subtext classes |
| title_link_classes | string[] | [] | Extra link classes |

### Usage

```twig
{% include "@Ui/component/title.html.twig" with {
    title_text: 'Latest Articles',
    title_markup: 'h2',
    title_link: '/articles'
} only %}
```

---

## subtitle

- **Template**: `@Ui/component/subtitle.html.twig`
- **Pattern**: include
- **SCSS**: `@Ui/scss/component/subtitle`

### Variables

| Variable | Type | Default | Description |
|----------|------|---------|-------------|
| subtitle | string | required | Subtitle text (striptags applied) |
| markup | string | `'div'` | HTML tag |
| href | string | null | Wraps text in `<a>` |
| classes | string[] | [] | Extra CSS classes |

### Usage

```twig
{% include "@Ui/component/subtitle.html.twig" with {
    subtitle: 'See all trending topics',
    href: '/trending',
    markup: 'p'
} only %}
```

---

## share

- **Template**: `@Ui/component/share.html.twig`
- **Pattern**: include (NOT a macro)
- **SCSS**: `@Ui/scss/component/share`
- **JS**: `@Ui/js/module/share/share` (needs `js-share` class on container)

### Variables

| Variable | Type | Default | Description |
|----------|------|---------|-------------|
| txt_wording | string | null | Share button label text |
| data_title | string | null | Shared content title |
| data_text | string | null | Shared content description |
| data_href | string | null | Shared URL |
| data_tracking | object | {} | Tracking data attributes |
| share_container_class | string[] | [] | Extra container classes |
| icon_container_class | string[] | [] | Extra icon container classes |
| icon_class | string[] | [] | Extra icon classes |
| txt_container_class | string[] | [] | Extra text container classes |

### Usage

```twig
{% include "@Ui/component/share.html.twig" with {
    txt_wording: 'Share',
    data_title: article.title,
    data_href: url('article_show', { slug: article.slug })
} only %}
```

---

## cta_subcategory

- **Template**: `@Ui/component/cta_subcategory.html.twig`
- **Pattern**: include
- **SCSS**: `@Ui/scss/component/cta_subcategory`

### Variables

| Variable | Type | Default | Description |
|----------|------|---------|-------------|
| btn_href | string | required | CTA link URL |
| btn_title | string | required | CTA link text |
| cta_subcategory_article | bool | false | Article variant styling |

### Usage

```twig
{% include "@Ui/component/cta_subcategory.html.twig" with {
    btn_href: '/category/tech',
    btn_title: 'See all Tech articles'
} only %}
```
