import { toggleClass } from "@Ui/js/dom/classes";
import { on } from "@Ui/js/dom/events";
import { setCookie } from "@Ui/js/tools/cookie";

const BTN_CLOSE_COOKIE_BANNER = document.getElementById("js-cookie-banner-submit");

export default function consentPolicyCookie() {

    const CONTAINER_COOKIE_BANNER = document.getElementById("js-cookie-banner-container");

    if (!CONTAINER_COOKIE_BANNER) {
        return false;
    }

    if (!BTN_CLOSE_COOKIE_BANNER) {
        return false;
    }

    on(BTN_CLOSE_COOKIE_BANNER, "click", () => {
        toggleClass(CONTAINER_COOKIE_BANNER, "active");
        setCookie('cookie_banner', true, 396);
    });
}
