<?php

use Symfony\Component\Config\Definition\Configurator\DefinitionConfigurator;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;

return static function (DefinitionConfigurator $definition): void {
    $createChildrenNode = function ($name, $maxDepth) use (&$createChildrenNode) {
        $builder = new TreeBuilder($name);
        $node = $builder->getRootNode();
    
        if ($maxDepth <= 0) {
            return $node;
        }
    
        $node
            ->arrayPrototype()
                ->children()
                    ->scalarNode('route')->isRequired()->end()
                    ->scalarNode('label')->isRequired()->end()
                    ->variableNode('route_parameters')->defaultNull()->end()
                    ->append($createChildrenNode('children', $maxDepth - 1))
                ->end()
            ->end();
    
        return $node;
    };

    $maxDepth = 4;

    $definition->rootNode()
        ->children()
            ->arrayNode('menus')
                ->useAttributeAsKey('name')
                ->arrayPrototype()
                    ->children()
                        ->append($createChildrenNode('children', $maxDepth))
                        ->end()
                    ->end()
                ->end()
            ->end()
        ->end()
    ;
};
