import { BODY, CLASS_BODY_HEADER_HIDDEN } from "../../constant/dom";
import { on } from "../../dom/events";
import { removeClass, addClass } from "../../dom/classes";

//Function header behavior on scroll
let windowTop =
  window.scrollY || window.pageYOffset || document.documentElement.scrollTop;

export function hideHeader() {
  let HEADER_HIDDEN = false;

  on(window, "scroll", () => {
    if (window.scrollY < 79) {
      removeClass(BODY, CLASS_BODY_HEADER_HIDDEN);
      windowTop = window.scrollY;
      return false;
    }

    if (window.scrollY > windowTop && !HEADER_HIDDEN) {
      addClass(BODY, CLASS_BODY_HEADER_HIDDEN);
      HEADER_HIDDEN = true;
    }

    if (window.scrollY < windowTop && HEADER_HIDDEN) {
      removeClass(BODY, CLASS_BODY_HEADER_HIDDEN);
      HEADER_HIDDEN = false;
    }

    windowTop = window.scrollY;
  });
}
