import { on } from "@Ui/js/dom/events";
import { addClass, removeClass } from "@Ui/js/dom/classes";

const PIP_CLASS = 'player-pip';
const EXTEND_CLASS = 'player-pip-extend';

let buttonsInjected = false;

let pipRemoved = false;
let pipExtended = false;

const playerMain = document.getElementById('player-main');

function setClosePipButton(buttonHolder) {
  const pipButton = document.createElement('button');
  pipButton.classList.add('player-pip-btn', 'player-pip-close', 'ui-icons');
  pipButton.textContent = 'close2';
  buttonHolder.appendChild(pipButton);

  on(pipButton, 'click', () => {
    removeClass(playerMain, PIP_CLASS);
    pipRemoved = true;
  });
}

function setExtendPipButton(buttonHolder) {
  const extendButton = document.createElement('button');
  extendButton.classList.add('player-pip-btn', 'player-pip-extend', 'ui-icons');
  extendButton.textContent = 'extend';
  buttonHolder.appendChild(extendButton);

  on(extendButton, 'click', () => {
    if (pipExtended) {
      removeClass(playerMain, EXTEND_CLASS);
      pipExtended = false;
    } else {
      addClass(playerMain, EXTEND_CLASS);
      pipExtended = true;
    }
  });
}

// function setPlayPauseButton(buttonHolder, player) {
//   const playPauseButton = document.createElement('button');
//   playPauseButton.classList.add('player-pip-btn', 'player-pip-play-pause', 'ui-icons');
//   playPauseButton.textContent = 'pause';
//   buttonHolder.appendChild(playPauseButton);

//   const PAUSE = window.dailymotion.events['VIDEO_PAUSE'];
//   const VIDEO_PLAYING = window.dailymotion.events['VIDEO_PLAYING'];

//   player.on(PAUSE, () => {
//     playPauseButton.textContent = 'player2';
//   });

//   player.on(VIDEO_PLAYING, () => {
//     playPauseButton.textContent = 'pause';
//   });

//   on(playPauseButton, 'click', async () => {
//     const state = await player.getState();
//     if (state.playerIsPlaying) {
//       player.pause();
//     } else {
//       player.play();
//     }
//   });
// }

function setMuteButton(buttonHolder, player, state) {
  const muteButton = document.createElement('button');
  muteButton.classList.add('player-pip-btn', 'player-pip-mute', 'ui-icons');

  if (state.playerIsMuted) {
    muteButton.textContent = 'volume_no';
  } else {
    muteButton.textContent = 'volume_on';
  }

  buttonHolder.appendChild(muteButton);

  on(muteButton, 'click', async () => {
    const state = await player.getState();

    if (!state.playerIsMuted) {
      if (state.playerVolume <= 0.01) {
        player.setVolume(100);
        muteButton.textContent = 'volume_on';
      } else {
        player.setMute(true);
        muteButton.textContent = 'volume_no';
      }
    } else {
      player.setMute(false);
      player.setVolume(100);
      muteButton.textContent = 'volume_on';
    }
  });
}

async function handlePipButtons(player) {
  if (buttonsInjected || !playerMain || !player) {
    return;
  }

  const PLAYER_ANCHOR = playerMain.querySelector('.player-item');

  const buttonHolder = document.createElement('div');
  buttonHolder.classList.add('player-pip-buttons');

  const state = await player.getState();

  //setPlayPauseButton(buttonHolder, player);
  setMuteButton(buttonHolder, player, state);
  setExtendPipButton(buttonHolder);
  setClosePipButton(buttonHolder);

  PLAYER_ANCHOR.appendChild(buttonHolder);

  buttonsInjected = true;
}

/**
 * Intersection Observer for player-main element
 * Adds player-pip class when the element passes the viewport while scrolling down
 */
export default function initPlayerPip(player) {
  if (!playerMain || !player) {
    return;
  }

  const observer = new IntersectionObserver((entries) => {
    if (pipRemoved) {
      return;
    }

    entries.forEach((entry) => {
      // Only set PIP when player is not visible AND above the fold (scrolled past)
      // Never set PIP when player is below the viewport
      const isAboveViewport = entry.boundingClientRect.top < 0;
      const isBelowViewport = entry.boundingClientRect.top > window.innerHeight;

      if (!entry.isIntersecting && isAboveViewport) {
        // Element has passed the viewport while scrolling down (above the fold)
        addClass(playerMain, PIP_CLASS);
        handlePipButtons(player);
      } else if (entry.isIntersecting || isBelowViewport) {
        // Element is back in viewport OR below viewport - remove PIP
        removeClass(playerMain, PIP_CLASS);
      }
    });
  },
  {
    threshold: 0.75,
    rootMargin: '0px',
  });

  observer.observe(playerMain);
}

