let previousRun = null;

export function hasAdblock() {
  if (previousRun) {
    // if we already detected an adblock, return this value now
    return previousRun;
  }

  let bait = document.querySelector(".easyAdsBox");
  let baitHidden = false;

  if (bait) {
    baitHidden = bait.offsetHeight === 0;
    bait.remove();
    bait = null;
  }

  previousRun = baitHidden;

  return baitHidden;
}

export function noAds() {
  return (
    window.location.hash && /no-ads$/.exec(window.location.hash.split('#')[1])
  );
}