import { hit } from "../tracking"
import { hitPixel } from "../tracking/pixel"

function setPixelUrl(pixel, action) {
  return `${pixel}${action}&domain=${window.location.host}&referrer=${document.referrer}`
}

function handleNativeAnchorHit(webediaPlayerInstance, trackingObj) {
  webediaPlayerInstance.addEventListener('quartile', (QuartilePayload) => {
    const quartile = QuartilePayload.detail.quartile;

    const GA_OBJ = {
      ...trackingObj?.ga,
      video_id: trackingObj?.videoId,
      player_position: trackingObj?.position
    };
    const BASE_PIXEL_URL = trackingObj?.pixel;
    const EVENT_CATEGORY = trackingObj?.category;

    switch(quartile) {
      case 0:
        hit(`${EVENT_CATEGORY}_video_content_starts`, GA_OBJ);
        hitPixel(setPixelUrl(BASE_PIXEL_URL, 'video_content_starts'));
        break;

      case 1:
        hit(`${EVENT_CATEGORY}_video_content_starts`, {...GA_OBJ, 'video_progression': 'play_25'});
        hitPixel(setPixelUrl(BASE_PIXEL_URL, 'video_progression_play_25'));
        break;

      case 2:
        hit(`${EVENT_CATEGORY}_video_content_starts`, {...GA_OBJ, 'video_progression': 'play_50'});
        hitPixel(setPixelUrl(BASE_PIXEL_URL, 'video_progression_play_50'));
        break;

      case 3:
        hit(`${EVENT_CATEGORY}_video_content_starts`, {...GA_OBJ, 'video_progression': 'play_75'});
        hitPixel(setPixelUrl(BASE_PIXEL_URL, 'video_progression_play_75'));
        break;

      case 4:
        hit(`${EVENT_CATEGORY}_video_content_starts`, {...GA_OBJ, 'video_progression': 'play_100'});
        hitPixel(setPixelUrl(BASE_PIXEL_URL, 'video_progression_play_100'));
        break;
    }
  });
}

export default function trackNativeAnchorPlayerEvent({webediaPlayerInstance, trackingObj, player}) {
  const playersToTrack = window.nativeAnchorTrackingData?.players;

  if (!playersToTrack || !Object.keys(playersToTrack).length) {
    return false;
  }

  const playerTrackingData = playersToTrack[webediaPlayerInstance.container.id];

  if (!playerTrackingData) {
    return false;
  }

  const tmp_trackingObj = {...trackingObj, ga: playerTrackingData?.ga, pixel: playerTrackingData?.pixel, category: playerTrackingData?.meta?.category};

  trackingObj = tmp_trackingObj;

  handleNativeAnchorHit(webediaPlayerInstance, trackingObj);
}
