
import { addClass, removeClass } from "../../dom/classes";
import { on } from "../../dom/events";

const DARK_MODE_KEY = 'dark_mode';
const DARK_MODE_CLASS = 'dark';

const ROOT_ELEMENT = document.querySelector('html');
const DARK_MODE_BTN = document.getElementById('dark-mode');

let darkModeStatus = false;

function handleDarkModeAction() {
  on(DARK_MODE_BTN, 'click', () => {
    if (darkModeStatus) {
      removeClass(ROOT_ELEMENT, DARK_MODE_CLASS);
      darkModeStatus = false;
      DARK_MODE_BTN.textContent = 'moon';
    } else {
      addClass(ROOT_ELEMENT, DARK_MODE_CLASS);
      darkModeStatus = true;
      DARK_MODE_BTN.textContent = 'sun';
    }

    window.localStorage.setItem(DARK_MODE_KEY, darkModeStatus);
  });
}

function getDarkModeStatus() {
  if (window.localStorage.getItem(DARK_MODE_KEY) == 'true') {
    addClass(ROOT_ELEMENT, DARK_MODE_CLASS);
    DARK_MODE_BTN.textContent = 'sun';
    darkModeStatus = true;
  }
}

export default function initDarkMode() {
  getDarkModeStatus();
  handleDarkModeAction();
}
