import { on } from "../dom/events";

export default function setupTouchEvents(container, cb = []) {
    let startX = 0;
    let startY = 0;
    let isDragging = false;

    on(container, "touchstart", (e) => {
        startX = e.touches[0].clientX;
        startY = e.touches[0].clientY;
        isDragging = false;
    });

    on(container, "touchmove", (e) => {
        if (!startX || !startY) return;

        const currentX = e.touches[0].clientX;
        const currentY = e.touches[0].clientY;
        const diffX = startX - currentX;
        const diffY = startY - currentY;

        // Only consider it a drag if horizontal movement is greater than vertical
        if (Math.abs(diffX) > Math.abs(diffY) && Math.abs(diffX) > 10) {
            isDragging = true;
            e.preventDefault();
        }
    });

    on(container, "touchend", (e) => {
        if (!isDragging || !startX) return;

        const endX = e.changedTouches[0].clientX;
        const diffX = startX - endX;
        const threshold = 50;

        if (Math.abs(diffX) > threshold) {
            if (diffX > 0) {
                cb[0]?.();
            } else {
                cb[1]?.();
            }
        }

        startX = 0;
        startY = 0;
        isDragging = false;
    });
}
